/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.ICloneable;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.GenericReflection;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CloneHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CloneHelper.class);
    private static final CloneHelper s_aInstance = new CloneHelper();

    private CloneHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static <DATATYPE> DATATYPE _getGenericClone(@Nonnull DATATYPE DATATYPE) {
        if (DATATYPE instanceof ICloneable) {
            return ((ICloneable)GenericReflection.uncheckedCast(DATATYPE)).getClone();
        }
        try {
            try {
                return (DATATYPE)GenericReflection.invokeMethod(DATATYPE, "clone", new Object[0]);
            }
            catch (Exception exception) {
                try {
                    s_aLogger.warn("Failed to invoke clone on " + DATATYPE.getClass().getName());
                    Constructor<DATATYPE> constructor = GenericReflection.findConstructor(DATATYPE, DATATYPE.getClass());
                    if (constructor == null) return null;
                    return constructor.newInstance(DATATYPE);
                }
                catch (Exception exception2) {
                    s_aLogger.error("Failed to clone object of type '" + DATATYPE.getClass().getName() + "' because it has neither a (visible) clone method nor a copy constructor.", (Throwable)exception2);
                    return null;
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            s_aLogger.error("Failed to clone object of type '" + DATATYPE.getClass().getName() + "' because it has neither a (visible) clone method nor a copy constructor or the methods are invisible.");
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            s_aLogger.error("Failed to clone object of type '" + DATATYPE.getClass().getName() + "' because it has neither a clone method nor a (visible) copy constructor or the methods are invisible.");
            return null;
        }
    }

    @Nullable
    public static <DATATYPE> DATATYPE getClonedValue(@Nullable DATATYPE DATATYPE) {
        if (DATATYPE == null) {
            return null;
        }
        Class<?> clazz = DATATYPE.getClass();
        if (ClassHelper.isPrimitiveWrapperType(clazz) || DATATYPE instanceof String || clazz.getAnnotation(Immutable.class) != null) {
            return DATATYPE;
        }
        return CloneHelper._getGenericClone(DATATYPE);
    }
}

