/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.convert.collections;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.convert.IUnidirectionalConverter;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ArrayConversionHelper {
    private static final ArrayConversionHelper s_aInstance = new ArrayConversionHelper();

    private ArrayConversionHelper() {
    }

    @Nonnull
    public static <SRCTYPE, DSTTYPE> DSTTYPE[] getConverted(@Nonnull SRCTYPE[] SRCTYPEArray, @Nonnull IUnidirectionalConverter<SRCTYPE, DSTTYPE> iUnidirectionalConverter, @Nonnull Class<DSTTYPE> clazz) {
        DSTTYPE[] DSTTYPEArray = ArrayHelper.newArray(clazz, SRCTYPEArray.length);
        for (int i = 0; i < SRCTYPEArray.length; ++i) {
            DSTTYPEArray[i] = iUnidirectionalConverter.convert(SRCTYPEArray[i]);
        }
        return DSTTYPEArray;
    }

    @Nonnull
    public static <SRCTYPE, DSTTYPE> DSTTYPE[] newArray(@Nonnull Collection<? extends SRCTYPE> collection, @Nonnull IUnidirectionalConverter<SRCTYPE, DSTTYPE> iUnidirectionalConverter, @Nonnull Class<DSTTYPE> clazz) {
        if (collection == null) {
            throw new NullPointerException("list");
        }
        if (iUnidirectionalConverter == null) {
            throw new NullPointerException("converter");
        }
        DSTTYPE[] DSTTYPEArray = ArrayHelper.newArray(clazz, collection.size());
        int n = 0;
        for (SRCTYPE SRCTYPE : collection) {
            DSTTYPEArray[n++] = iUnidirectionalConverter.convert(SRCTYPE);
        }
        return DSTTYPEArray;
    }

    @Nonnull
    public static <SRCTYPE, DSTTYPE> DSTTYPE[] newArray(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull IUnidirectionalConverter<SRCTYPE, DSTTYPE> iUnidirectionalConverter, @Nonnull Class<DSTTYPE> clazz) {
        if (iUnidirectionalConverter == null) {
            throw new NullPointerException("converter");
        }
        DSTTYPE[] DSTTYPEArray = ArrayHelper.newArray(clazz, ArrayHelper.getSize(SRCTYPEArray));
        if (SRCTYPEArray != null) {
            int n = 0;
            for (SRCTYPE SRCTYPE : SRCTYPEArray) {
                DSTTYPEArray[n++] = iUnidirectionalConverter.convert(SRCTYPE);
            }
        }
        return DSTTYPEArray;
    }
}

