/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.attrs;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.attrs.IReadonlyAttributeContainer;
import com.phloc.commons.collections.attrs.MapBasedAttributeContainer;
import com.phloc.commons.state.EChange;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MapBasedAttributeContainerThreadSafe
extends MapBasedAttributeContainer {
    protected final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();

    public MapBasedAttributeContainerThreadSafe() {
    }

    public MapBasedAttributeContainerThreadSafe(@Nonnull Map<String, Object> map) {
        super(map);
    }

    public MapBasedAttributeContainerThreadSafe(@Nonnull IReadonlyAttributeContainer iReadonlyAttributeContainer) {
        if (iReadonlyAttributeContainer == null) {
            throw new NullPointerException("cont");
        }
        this.m_aAttrs.putAll(iReadonlyAttributeContainer.getAllAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAttribute(@Nullable String string) {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = super.containsAttribute(string);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, Object> getAllAttributes() {
        this.m_aRWLock.readLock().lock();
        try {
            Map<String, Object> map = ContainerHelper.newMap(this.m_aAttrs);
            return map;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getAttributeObject(@Nullable String string) {
        this.m_aRWLock.readLock().lock();
        try {
            Object object = super.getAttributeObject(string);
            return object;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange setAttribute(@Nonnull String string, @Nullable Object object) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = super.setAttribute(string, object);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange removeAttribute(@Nullable String string) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = super.removeAttribute(string);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Enumeration<String> getAttributeNames() {
        this.m_aRWLock.readLock().lock();
        try {
            Enumeration<String> enumeration = ContainerHelper.getEnumeration(ContainerHelper.newSet(this.m_aAttrs.keySet()));
            return enumeration;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllAttributeNames() {
        this.m_aRWLock.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(this.m_aAttrs.keySet());
            return set;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<Object> getAllAttributeValues() {
        this.m_aRWLock.readLock().lock();
        try {
            List<Object> list = ContainerHelper.newList(this.m_aAttrs.values());
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnegative
    public int getAttributeCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = super.getAttributeCount();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsNoAttribute() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = super.containsNoAttribute();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange clear() {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = super.clear();
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAndSetAttributeFlag(@Nonnull String string) {
        this.m_aRWLock.writeLock().lock();
        try {
            boolean bl = super.getAndSetAttributeFlag(string);
            return bl;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = super.equals(object);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = super.hashCode();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.m_aRWLock.readLock().lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }
}

