/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.attrs;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.attrs.AbstractReadonlyAttributeContainer;
import com.phloc.commons.collections.attrs.IAttributeContainer;
import com.phloc.commons.collections.attrs.IReadonlyAttributeContainer;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MapBasedAttributeContainer
extends AbstractReadonlyAttributeContainer
implements IAttributeContainer {
    protected final Map<String, Object> m_aAttrs = new HashMap<String, Object>();

    public MapBasedAttributeContainer() {
    }

    public MapBasedAttributeContainer(@Nonnull Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        this.m_aAttrs.putAll(map);
    }

    public MapBasedAttributeContainer(@Nonnull IReadonlyAttributeContainer iReadonlyAttributeContainer) {
        if (iReadonlyAttributeContainer == null) {
            throw new NullPointerException("cont");
        }
        this.m_aAttrs.putAll(iReadonlyAttributeContainer.getAllAttributes());
    }

    @Override
    public boolean containsAttribute(@Nullable String string) {
        return string != null && this.m_aAttrs.containsKey(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, Object> getAllAttributes() {
        return ContainerHelper.newMap(this.m_aAttrs);
    }

    @Override
    @Nullable
    public Object getAttributeObject(@Nullable String string) {
        return string == null ? null : this.m_aAttrs.get(string);
    }

    @Override
    @Nonnull
    public EChange setAttribute(@Nonnull String string, @Nullable Object object) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (object == null) {
            return this.removeAttribute(string);
        }
        Object object2 = this.m_aAttrs.put(string, object);
        return EChange.valueOf(!EqualsUtils.equals(object, object2));
    }

    @Override
    @Nonnull
    public final EChange setAttribute(@Nonnull String string, boolean bl) {
        return this.setAttribute(string, (Object)bl);
    }

    @Override
    @Nonnull
    public final EChange setAttribute(@Nonnull String string, int n) {
        return this.setAttribute(string, (Object)n);
    }

    @Override
    @Nonnull
    public final EChange setAttribute(@Nonnull String string, long l) {
        return this.setAttribute(string, (Object)l);
    }

    @Override
    @Nonnull
    public final EChange setAttribute(@Nonnull String string, double d) {
        return this.setAttribute(string, (Object)d);
    }

    @Override
    @Nonnull
    public final EChange setAttributes(@Nullable Map<String, ?> map) {
        EChange eChange = EChange.UNCHANGED;
        if (map != null) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                eChange = eChange.or(this.setAttribute(entry.getKey(), entry.getValue()));
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    public EChange removeAttribute(@Nullable String string) {
        return EChange.valueOf(string != null && this.m_aAttrs.remove(string) != null);
    }

    @Override
    @Nonnull
    public Enumeration<String> getAttributeNames() {
        return ContainerHelper.getEnumeration(this.m_aAttrs.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllAttributeNames() {
        return ContainerHelper.newSet(this.m_aAttrs.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<Object> getAllAttributeValues() {
        return ContainerHelper.newList(this.m_aAttrs.values());
    }

    @Override
    @Nonnegative
    public int getAttributeCount() {
        return this.m_aAttrs.size();
    }

    @Override
    public boolean containsNoAttribute() {
        return this.m_aAttrs.isEmpty();
    }

    @Override
    public boolean getAndSetAttributeFlag(@Nonnull String string) {
        Object object = this.getAttributeObject(string);
        if (object != null) {
            return true;
        }
        this.setAttribute(string, Boolean.TRUE);
        return false;
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aAttrs.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aAttrs.clear();
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedAttributeContainer mapBasedAttributeContainer = (MapBasedAttributeContainer)object;
        return ((Object)this.m_aAttrs).equals(mapBasedAttributeContainer.m_aAttrs);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aAttrs)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("attrs", this.m_aAttrs).toString();
    }
}

