/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class LZWNode {
    private final int m_nTableIndex;
    private LZWNode[] m_aChildren;

    public LZWNode() {
        this.m_nTableIndex = -1;
    }

    public LZWNode(int n) {
        if (n < 0 || n > 4095) {
            throw new IllegalArgumentException("Illegal table index: " + n);
        }
        this.m_nTableIndex = n;
    }

    @Nonnegative
    public int getTableIndex() {
        if (this.m_nTableIndex < 0) {
            throw new IllegalStateException("This node has no table index!");
        }
        return this.m_nTableIndex;
    }

    public void setNode(@Nonnegative byte by, @Nonnull LZWNode lZWNode) {
        if (lZWNode == null) {
            throw new NullPointerException("node");
        }
        if (this.m_aChildren == null) {
            this.m_aChildren = new LZWNode[256];
        }
        this.m_aChildren[by & 0xFF] = lZWNode;
    }

    @Nullable
    public LZWNode getChildNode(byte by) {
        return this.m_aChildren == null ? null : this.m_aChildren[by & 0xFF];
    }

    @Nullable
    public LZWNode getNode(byte[] byArray) {
        byte by;
        LZWNode lZWNode = this;
        byte[] byArray2 = byArray;
        int n = byArray2.length;
        for (int i = 0; i < n && (lZWNode = lZWNode.getChildNode(by = byArray2[i])) != null; ++i) {
        }
        return lZWNode;
    }

    public String toString() {
        return new ToStringGenerator(null).append("index", this.m_nTableIndex).append("children#", ArrayHelper.getSize(this.m_aChildren)).toString();
    }
}

