/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.SleepWork;
import org.nuxeo.ecm.core.work.WorkManagerImpl;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.NXRuntimeTestCase;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.FileEventsTrackingFeature;
import org.nuxeo.runtime.trackers.files.FileEvent;

@Features(value={FileEventsTrackingFeature.class})
public class WorkManagerTest
extends NXRuntimeTestCase {
    protected static final String CATEGORY = "SleepWork";
    protected static final String QUEUE = "SleepWork";
    protected WorkManager service;
    protected boolean dontClearCompletedWork;
    @Inject
    public FeaturesRunner runner;
    protected FileEventsTrackingFeature feature;

    private static void assertSetEquals(List<String> expected, List<String> actual) {
        Assert.assertEquals(new HashSet<String>(expected), new HashSet<String>(actual));
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.doDeploy();
        this.fireFrameworkStarted();
        this.service = (WorkManager)Framework.getLocalService(WorkManager.class);
    }

    protected void doDeploy() throws Exception {
        this.deployBundle("org.nuxeo.ecm.core.event");
        this.deployContrib("org.nuxeo.ecm.core.event.test", "test-workmanager-config.xml");
    }

    @After
    public void tearDown() throws Exception {
        if (this.service != null && !this.dontClearCompletedWork) {
            this.service.clearCompletedWork(0L);
        }
        super.tearDown();
    }

    public boolean persistent() {
        return false;
    }

    @Test
    public void testBasics() {
        Assert.assertNotNull((Object)this.service);
        this.service.clearCompletedWork(0L);
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.RUNNING));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
    }

    @Test
    public void testWorkManagerConfig() throws Exception {
        SleepWork work = new SleepWork(1L);
        Assert.assertEquals((Object)"SleepWork", (Object)work.getCategory());
        Assert.assertEquals((Object)"SleepWork", (Object)this.service.getCategoryQueueId("SleepWork"));
        WorkQueueDescriptor qd = this.service.getWorkQueueDescriptor("SleepWork");
        Assert.assertEquals((Object)"SleepWork", (Object)qd.id);
        Assert.assertEquals((Object)"Sleep Work Queue", (Object)qd.name);
        Assert.assertEquals((long)2L, (long)qd.maxThreads);
        Assert.assertFalse((boolean)qd.usePriority);
        Assert.assertEquals((long)1234L, (long)qd.clearCompletedAfterSeconds);
        Assert.assertEquals(Collections.singleton("SleepWork"), (Object)qd.categories);
    }

    @Test
    public void testWorkManagerWork() throws Exception {
        int duration = 3000;
        SleepWork work = new SleepWork((long)duration, false);
        this.service.schedule((Work)work);
        Thread.sleep(duration / 3);
        Assert.assertEquals((Object)Work.State.RUNNING, (Object)this.service.getWorkState(work.getId()));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        Assert.assertEquals((long)1L, (long)this.service.getQueueSize("SleepWork", Work.State.RUNNING));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Thread.sleep(duration);
        Assert.assertEquals((long)1L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.RUNNING));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((Object)Work.State.COMPLETED, (Object)this.service.getWorkState(work.getId()));
        Assert.assertTrue((work.getSchedulingTime() != 0L ? 1 : 0) != 0);
    }

    @Test
    public void testWorkManagerScheduling() throws Exception {
        Assert.assertEquals(Collections.emptyList(), (Object)this.service.listWorkIds("SleepWork", Work.State.COMPLETED));
        int duration = 5000;
        SleepWork work1 = new SleepWork((long)duration, false, "1");
        SleepWork work2 = new SleepWork((long)duration, false, "2");
        SleepWork work3 = new SleepWork((long)duration, false, "3");
        this.service.schedule((Work)work1);
        this.service.schedule((Work)work2);
        this.service.schedule((Work)work3);
        Thread.sleep(duration / 2);
        Assert.assertEquals((Object)Work.State.RUNNING, (Object)this.service.getWorkState("1"));
        Assert.assertEquals((Object)Work.State.RUNNING, (Object)this.service.getWorkState("2"));
        Assert.assertEquals((Object)Work.State.SCHEDULED, (Object)this.service.getWorkState("3"));
        Assert.assertEquals(Arrays.asList("3"), (Object)this.service.listWorkIds("SleepWork", Work.State.SCHEDULED));
        WorkManagerTest.assertSetEquals(Arrays.asList("1", "2"), this.service.listWorkIds("SleepWork", Work.State.RUNNING));
        WorkManagerTest.assertSetEquals(Arrays.asList("1", "2", "3"), this.service.listWorkIds("SleepWork", null));
        Assert.assertEquals(Collections.emptyList(), (Object)this.service.listWorkIds("SleepWork", Work.State.COMPLETED));
        if (Boolean.FALSE.booleanValue()) {
            SleepWork work4 = new SleepWork((long)duration, false, "3");
            this.service.schedule((Work)work4, WorkManager.Scheduling.IF_NOT_SCHEDULED);
            Assert.assertEquals((Object)Work.State.CANCELED, (Object)work4.getWorkInstanceState());
            SleepWork work5 = new SleepWork((long)duration, false, "1");
            this.service.schedule((Work)work5, WorkManager.Scheduling.IF_NOT_RUNNING);
            Assert.assertEquals((Object)Work.State.CANCELED, (Object)work5.getWorkInstanceState());
            SleepWork work6 = new SleepWork((long)duration, false, "1");
            this.service.schedule((Work)work6, WorkManager.Scheduling.IF_NOT_RUNNING_OR_SCHEDULED);
            Assert.assertEquals((Object)Work.State.CANCELED, (Object)work6.getWorkInstanceState());
        }
        SleepWork work7 = new SleepWork((long)duration, false, "3");
        this.service.schedule((Work)work7, WorkManager.Scheduling.CANCEL_SCHEDULED);
        Assert.assertEquals((Object)Work.State.SCHEDULED, (Object)work7.getWorkInstanceState());
        boolean completed = this.service.awaitCompletion((long)(duration * 2), TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)completed);
        Assert.assertEquals((Object)Work.State.COMPLETED, (Object)this.service.getWorkState("1"));
        Assert.assertEquals((Object)Work.State.COMPLETED, (Object)this.service.getWorkState("2"));
        Assert.assertEquals((Object)Work.State.COMPLETED, (Object)this.service.getWorkState("3"));
        Assert.assertEquals(Collections.emptyList(), (Object)this.service.listWorkIds("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals(Collections.emptyList(), (Object)this.service.listWorkIds("SleepWork", Work.State.RUNNING));
        Assert.assertEquals(Collections.emptyList(), (Object)this.service.listWorkIds("SleepWork", null));
        WorkManagerTest.assertSetEquals(Arrays.asList("1", "2", "3"), this.service.listWorkIds("SleepWork", Work.State.COMPLETED));
    }

    @Test
    @Ignore
    public void testWorkManagerShutdown() throws Exception {
        int duration = 2000;
        SleepWork work1 = new SleepWork((long)duration, false, "1");
        SleepWork work2 = new SleepWork((long)duration, false, "2");
        SleepWork work3 = new SleepWork((long)duration, false, "3");
        this.service.schedule((Work)work1);
        this.service.schedule((Work)work2);
        this.service.schedule((Work)work3);
        Thread.sleep(duration / 2);
        Assert.assertEquals((Object)Work.State.RUNNING, (Object)this.service.getWorkState("1"));
        Assert.assertEquals((Object)Work.State.RUNNING, (Object)this.service.getWorkState("2"));
        Assert.assertEquals((Object)Work.State.SCHEDULED, (Object)this.service.getWorkState("3"));
        this.dontClearCompletedWork = true;
        boolean terminated = this.service.shutdown((long)(duration * 2), TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)terminated);
        Assert.assertEquals((Object)Work.State.SCHEDULED, (Object)work1.getWorkInstanceState());
        Assert.assertEquals((Object)Work.State.SCHEDULED, (Object)work2.getWorkInstanceState());
        Assert.assertEquals((Object)(this.persistent() ? Work.State.SCHEDULED : Work.State.CANCELED), (Object)work3.getWorkInstanceState());
        long remaining1 = work1.durationMillis;
        long remaining2 = work2.durationMillis;
        long remaining3 = work3.durationMillis;
        Assert.assertTrue((String)("remaining1 " + remaining1), (remaining1 < (long)duration ? 1 : 0) != 0);
        Assert.assertTrue((String)("remaining2 " + remaining2), (remaining2 < (long)duration ? 1 : 0) != 0);
        Assert.assertEquals((long)duration, (long)remaining3);
    }

    @Test
    public void testWorkManagerDisableProcessing() throws Exception {
        Assume.assumeTrue((boolean)this.persistent());
        this.deployContrib("org.nuxeo.ecm.core.event.test", "test-workmanager-disablequeue.xml");
        int duration = 2000;
        SleepWork work1 = new SleepWork((long)duration, false);
        this.service.schedule((Work)work1);
        Thread.sleep(duration / 2);
        Assert.assertEquals((long)1L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.RUNNING));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        Thread.sleep(2 * duration);
        Assert.assertEquals((long)1L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        WorkQueueDescriptor descr = new WorkQueueDescriptor();
        descr.id = "SleepWork";
        descr.processing = Boolean.TRUE;
        descr.categories = Collections.emptySet();
        ((WorkManagerImpl)this.service).activateQueue(descr);
        Thread.sleep(duration / 2);
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((long)1L, (long)this.service.getQueueSize("SleepWork", Work.State.RUNNING));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        Thread.sleep(duration);
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.RUNNING));
        Assert.assertEquals((long)1L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
    }

    @Test
    public void testWorkManagerDisableProcessing2() throws Exception {
        Assume.assumeTrue((boolean)this.persistent());
        this.deployContrib("org.nuxeo.ecm.core.event.test", "test-workmanager-disablequeue2.xml");
        int duration = 2000;
        SleepWork work1 = new SleepWork((long)duration, false);
        this.service.schedule((Work)work1);
        Thread.sleep(duration / 2);
        Assert.assertEquals((long)1L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.RUNNING));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        Thread.sleep(2 * duration);
        Assert.assertEquals((long)1L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        WorkQueueDescriptor descr = new WorkQueueDescriptor();
        descr.id = "SleepWork";
        descr.processing = Boolean.TRUE;
        descr.categories = Collections.emptySet();
        ((WorkManagerImpl)this.service).activateQueue(descr);
        Thread.sleep(duration / 2);
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((long)1L, (long)this.service.getQueueSize("SleepWork", Work.State.RUNNING));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        Thread.sleep(duration);
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.RUNNING));
        Assert.assertEquals((long)1L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
    }

    @Before
    public void injectFeature() {
        this.feature = (FileEventsTrackingFeature)this.runner.getFeature(FileEventsTrackingFeature.class);
    }

    @Test
    public void transientFilesWorkAreCleaned() throws Exception {
        File file = this.feature.resolveAndCreate(new File("pfouh"));
        this.service.schedule((Work)new CreateFile(file));
        this.service.awaitCompletion(5L, TimeUnit.SECONDS);
    }

    protected static class CreateFile
    extends AbstractWork
    implements Serializable {
        private final File file;
        private static final long serialVersionUID = 1L;

        protected CreateFile(File file) {
            this.file = file;
        }

        public String getTitle() {
            return "pfouh";
        }

        public void work() throws Exception {
            FileEvent.onFile((Object)this, (File)this.file, (Object)this).send();
        }
    }
}

