/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.work.SleepWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.NXRuntimeTestCase;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class WorkManagerTXTest
extends NXRuntimeTestCase {
    protected static final String CATEGORY = "SleepWork";
    protected static final String QUEUE = "SleepWork";
    protected WorkManager service;
    protected boolean dontClearCompletedWork;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployBundle("org.nuxeo.runtime.jtajca");
        this.deployBundle("org.nuxeo.ecm.core.event");
        this.deployContrib("org.nuxeo.ecm.core.event.test", "test-workmanager-config.xml");
        this.fireFrameworkStarted();
        this.service = (WorkManager)Framework.getLocalService(WorkManager.class);
        Assert.assertNotNull((Object)this.service);
        this.service.clearCompletedWork(0L);
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.RUNNING));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        TransactionHelper.startTransaction();
    }

    @After
    public void tearDown() throws Exception {
        if (!this.dontClearCompletedWork) {
            this.service.clearCompletedWork(0L);
        }
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.setTransactionRollbackOnly();
            TransactionHelper.commitOrRollbackTransaction();
        }
        super.tearDown();
    }

    @Test
    public void testWorkManagerPostCommit() throws Exception {
        int duration = 1000;
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        SleepWork work = new SleepWork((long)duration, false);
        this.service.schedule((Work)work, true);
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        TransactionHelper.commitOrRollbackTransaction();
        Thread.sleep(duration + 1000);
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((long)1L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        Assert.assertEquals((Object)Work.State.COMPLETED, (Object)work.getWorkInstanceState());
    }

    @Test
    public void testWorkManagerRollback() throws Exception {
        Assert.assertTrue((boolean)TransactionHelper.isTransactionActive());
        int duration = 1000;
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        SleepWork work = new SleepWork((long)duration, false);
        this.service.schedule((Work)work, true);
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        TransactionHelper.setTransactionRollbackOnly();
        TransactionHelper.commitOrRollbackTransaction();
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals((long)0L, (long)this.service.getQueueSize("SleepWork", Work.State.COMPLETED));
        Assert.assertEquals((Object)Work.State.CANCELED, (Object)work.getWorkInstanceState());
    }
}

