/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scheduler;

import com.google.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.core.work.api.WorkSchedulePath;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;
import org.nuxeo.runtime.test.runner.RuntimeFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class, LogCaptureFeature.class})
@Deploy(value={"org.nuxeo.ecm.core.event"})
@LogCaptureFeature.FilterWith(value=ChainFilter.class)
public class WorkErrorsAreTracableTest {
    @Inject
    protected WorkManager manager;
    @Inject
    protected LogCaptureFeature.Result result;
    protected boolean beforeCapturePath;

    @Test
    public void captureSimple() throws InterruptedException, LogCaptureFeature.NoLogCaptureFilterException {
        Fail work = new Fail();
        this.manager.schedule((Work)work);
        WorkSchedulePath.Trace error = this.awaitFailure((Work)work);
        Assert.assertNotNull((Object)error);
    }

    @Test
    public void captureChained() throws InterruptedException, LogCaptureFeature.NoLogCaptureFilterException {
        Nest work = new Nest();
        this.manager.schedule((Work)work);
        WorkSchedulePath.Trace error = this.awaitFailure((Work)work);
        WorkSchedulePath.Trace cause = (WorkSchedulePath.Trace)error.getCause();
        Assert.assertEquals((Object)work.getSchedulePath(), (Object)cause.path());
    }

    protected WorkSchedulePath.Trace awaitFailure(Work work) throws InterruptedException, LogCaptureFeature.NoLogCaptureFilterException {
        boolean completed = this.manager.awaitCompletion(1000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)completed);
        this.result.assertHasEvent();
        LoggingEvent loggingEvent = (LoggingEvent)this.result.getCaughtEvents().get(0);
        WorkSchedulePath.Trace trace = (WorkSchedulePath.Trace)loggingEvent.getThrowableInformation().getThrowable();
        this.assertIsRootWork(work, trace);
        return trace;
    }

    protected void assertIsRootWork(Work work, WorkSchedulePath.Trace error) {
        Throwable cause = error.getCause();
        while (cause != null && cause != error) {
            error = (WorkSchedulePath.Trace)cause;
        }
        Assert.assertEquals((Object)work.getSchedulePath(), (Object)error.path());
    }

    public static class ChainFilter
    implements LogCaptureFeature.Filter {
        public boolean accept(LoggingEvent event) {
            String category = event.getLogger().getName();
            return WorkSchedulePath.class.getName().equals(category);
        }
    }

    protected class Nest
    extends AbstractWork {
        private static final long serialVersionUID = 1L;
        protected Work sub;

        protected Nest() {
        }

        public String getTitle() {
            return Nest.class.getSimpleName();
        }

        public void work() throws Exception {
            this.sub = new Fail();
            WorkErrorsAreTracableTest.this.manager.schedule(this.sub);
        }
    }

    protected static class Fail
    extends AbstractWork {
        private static final long serialVersionUID = 1L;

        protected Fail() {
        }

        public String getTitle() {
            return Nest.class.getSimpleName();
        }

        public void work() throws Exception {
            throw new Error();
        }

        public static class Error
        extends java.lang.Error {
            private static final long serialVersionUID = 1L;
        }
    }
}

