/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scheduler;

import java.util.Calendar;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.scheduler.DummyEventListener;
import org.nuxeo.ecm.core.scheduler.Schedule;
import org.nuxeo.ecm.core.scheduler.ScheduleImpl;
import org.nuxeo.ecm.core.scheduler.SchedulerService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.NXRuntimeTestCase;

public class TestSchedulerService
extends NXRuntimeTestCase {
    protected void waitUntilDummyEventListenerIsCalled(int maxRetry) throws Exception {
        this.waitUntilDummyEventListenerIsCalled(maxRetry, 1);
    }

    protected void waitUntilDummyEventListenerIsCalled(int maxRetry, int minCountValue) throws Exception {
        long count = DummyEventListener.getCount();
        for (int retry = 0; count < (long)minCountValue && retry < maxRetry * 2; ++retry) {
            Thread.sleep(500L);
            count = DummyEventListener.getCount();
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployBundle("org.nuxeo.ecm.core.event");
        this.deployContrib("org.nuxeo.ecm.core.event.test", "OSGI-INF/test-scheduler-eventlistener.xml");
        this.fireFrameworkStarted();
        DummyEventListener.setCount(0L);
    }

    @Test
    public void testScheduleRegistration() throws Exception {
        this.deployContrib("org.nuxeo.ecm.core.event.test", "OSGI-INF/test-scheduler-config.xml");
        this.fireFrameworkStarted();
        this.waitUntilDummyEventListenerIsCalled(10);
        long count = DummyEventListener.getCount();
        Assert.assertTrue((String)("count " + count), (count >= 1L ? 1 : 0) != 0);
    }

    @Test
    public void testScheduleManualRegistration() throws Exception {
        this.fireFrameworkStarted();
        SchedulerService service = (SchedulerService)Framework.getService(SchedulerService.class);
        ScheduleImpl schedule = new ScheduleImpl();
        schedule.cronExpression = "*/1 * * * * ?";
        schedule.id = "testing";
        schedule.username = "Administrator";
        schedule.eventId = "testEvent";
        schedule.eventCategory = "default";
        service.registerSchedule((Schedule)schedule);
        this.waitUntilDummyEventListenerIsCalled(10);
        long count = DummyEventListener.getCount();
        boolean unregistered = service.unregisterSchedule(schedule.id);
        Assert.assertTrue((boolean)unregistered);
    }

    @Test
    public void testScheduleManualRegistrationWithParameters() throws Exception {
        String cronExpression;
        this.fireFrameworkStarted();
        SchedulerService service = (SchedulerService)Framework.getService(SchedulerService.class);
        ScheduleImpl schedule = new ScheduleImpl();
        schedule.id = "testing";
        schedule.username = "Administrator";
        schedule.eventId = "testEvent";
        schedule.eventCategory = "default";
        Calendar cal = Calendar.getInstance();
        cal.add(13, 3);
        schedule.cronExpression = cronExpression = String.format("%s %s %s %s %s ? %s", cal.get(13), cal.get(12), cal.get(11), cal.get(5), cal.get(2) + 1, cal.get(1));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("flag", "1");
        service.registerSchedule((Schedule)schedule, parameters);
        this.waitUntilDummyEventListenerIsCalled(10);
        long count = DummyEventListener.getCount();
        Assert.assertTrue((String)("count " + count), (count < 0L ? 1 : 0) != 0);
        boolean unregistered = service.unregisterSchedule(schedule.id);
        Assert.assertFalse((boolean)unregistered);
    }

    @Test
    public void testDisableSchedule() throws Exception {
        this.deployContrib("org.nuxeo.ecm.core.event.test", "OSGI-INF/test-scheduler-config.xml");
        this.fireFrameworkStarted();
        this.waitUntilDummyEventListenerIsCalled(10);
        long count = DummyEventListener.getCount();
        Assert.assertTrue((count >= 1L ? 1 : 0) != 0);
        this.deployContrib("org.nuxeo.ecm.core.event.test", "OSGI-INF/test-scheduler-disabled-config.xml");
        count = DummyEventListener.getCount();
        Thread.sleep(5000L);
        long newCount = DummyEventListener.getCount();
        Assert.assertTrue((count == newCount ? 1 : 0) != 0);
    }

    @Test
    public void testOverrideSchedule() throws Exception {
        this.deployContrib("org.nuxeo.ecm.core.event.test", "OSGI-INF/test-scheduler-config.xml");
        this.fireFrameworkStarted();
        this.waitUntilDummyEventListenerIsCalled(10);
        long count = DummyEventListener.getCount();
        Assert.assertTrue((count >= 1L ? 1 : 0) != 0);
        this.deployContrib("org.nuxeo.ecm.core.event.test", "OSGI-INF/test-scheduler-override-config.xml");
        long newCount = DummyEventListener.getNewCount();
        for (int retry = 0; newCount <= 0L && retry < 20; ++retry) {
            Thread.sleep(500L);
            newCount = DummyEventListener.getNewCount();
        }
        newCount = DummyEventListener.getNewCount();
        Assert.assertTrue((newCount >= 1L ? 1 : 0) != 0);
    }
}

