/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.test;

import java.net.URL;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventServiceImpl;
import org.nuxeo.ecm.core.event.script.ScriptingPostCommitEventListener;
import org.nuxeo.ecm.core.event.test.EventListenerTest;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.test.NXRuntimeTestCase;

public class TestEventListenerContrib
extends NXRuntimeTestCase {
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployBundle("org.nuxeo.ecm.core.event");
        this.fireFrameworkStarted();
    }

    @Test
    public void testMerge() throws Exception {
        URL url = EventListenerTest.class.getClassLoader().getResource("test-listeners.xml");
        RuntimeContext rc = this.deployTestContrib("org.nuxeo.ecm.core.event", url);
        EventService service = (EventService)Framework.getService(EventService.class);
        EventServiceImpl serviceImpl = (EventServiceImpl)service;
        int N = 2;
        List inLineDescs = serviceImpl.getEventListenerList().getInlineListenersDescriptors();
        Assert.assertEquals((long)N, (long)inLineDescs.size());
        Assert.assertEquals((long)N, (long)serviceImpl.getEventListenerList().getInLineListeners().size());
        EventListenerDescriptor desc = (EventListenerDescriptor)inLineDescs.get(0);
        desc.setEnabled(false);
        serviceImpl.addEventListener(desc);
        Assert.assertEquals((long)(N - 1), (long)serviceImpl.getEventListenerList().getInLineListeners().size());
        desc.setEnabled(true);
        serviceImpl.addEventListener(desc);
        Assert.assertEquals((long)N, (long)serviceImpl.getEventListenerList().getInLineListeners().size());
        url = EventListenerTest.class.getClassLoader().getResource("test-PostCommitListeners.xml");
        this.deployTestContrib("org.nuxeo.ecm.core.event", url);
        List apcDescs = serviceImpl.getEventListenerList().getAsyncPostCommitListenersDescriptors();
        Assert.assertEquals((long)1L, (long)apcDescs.size());
        Assert.assertEquals((long)1L, (long)serviceImpl.getEventListenerList().getAsyncPostCommitListeners().size());
        desc = serviceImpl.getEventListener("testPostCommit");
        Assert.assertEquals((long)0L, (long)desc.getPriority());
        url = EventListenerTest.class.getClassLoader().getResource("test-PostCommitListeners2.xml");
        this.deployTestContrib("org.nuxeo.ecm.core.event", url);
        Assert.assertEquals((long)0L, (long)serviceImpl.getEventListenerList().getAsyncPostCommitListeners().size());
        Assert.assertEquals((long)1L, (long)serviceImpl.getEventListenerList().getSyncPostCommitListeners().size());
        boolean isScriptListener = false;
        PostCommitEventListener listener = (PostCommitEventListener)serviceImpl.getEventListenerList().getSyncPostCommitListeners().get(0);
        if (listener instanceof ScriptingPostCommitEventListener) {
            isScriptListener = true;
        }
        Assert.assertTrue((boolean)isScriptListener);
        desc = serviceImpl.getEventListener("testPostCommit");
        Assert.assertEquals((long)10L, (long)desc.getPriority());
        url = EventListenerTest.class.getClassLoader().getResource("test-PostCommitListeners3.xml");
        this.deployTestContrib("org.nuxeo.ecm.core.event", url);
        Assert.assertEquals((long)1L, (long)serviceImpl.getEventListenerList().getAsyncPostCommitListeners().size());
        Assert.assertEquals((long)0L, (long)serviceImpl.getEventListenerList().getSyncPostCommitListeners().size());
        listener = (PostCommitEventListener)serviceImpl.getEventListenerList().getAsyncPostCommitListeners().get(0);
        isScriptListener = listener instanceof ScriptingPostCommitEventListener;
        Assert.assertFalse((boolean)isScriptListener);
        desc = serviceImpl.getEventListener("testPostCommit");
        Assert.assertEquals((long)20L, (long)desc.getPriority());
    }
}

