/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.value.PrincipalName;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalNameEncoder {
    private static final String COMPONENT_SEPARATOR = "/";
    private static final String REALM_SEPARATOR = "@";

    public static DERSequence encode(KerberosPrincipal principal) {
        DERSequence vector = new DERSequence();
        vector.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)principal.getNameType())));
        vector.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)PrincipalNameEncoder.encodeNameSequence(principal)));
        return vector;
    }

    public static DERSequence encode(PrincipalName name) {
        DERSequence vector = new DERSequence();
        vector.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)name.getNameType())));
        vector.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)PrincipalNameEncoder.encodeNameSequence(name)));
        return vector;
    }

    private static DERSequence encodeNameSequence(KerberosPrincipal principal) {
        Iterator<String> it = PrincipalNameEncoder.getNameStrings(principal).iterator();
        DERSequence vector = new DERSequence();
        while (it.hasNext()) {
            vector.add((DEREncodable)DERGeneralString.valueOf((String)it.next()));
        }
        return vector;
    }

    private static List<String> getNameStrings(KerberosPrincipal principal) {
        String nameComponent = principal.getName().split(REALM_SEPARATOR)[0];
        String[] components = nameComponent.split(COMPONENT_SEPARATOR);
        return Arrays.asList(components);
    }

    private static DERSequence encodeNameSequence(PrincipalName name) {
        Iterator<String> it = PrincipalNameEncoder.getNameStrings(name).iterator();
        DERSequence vector = new DERSequence();
        while (it.hasNext()) {
            vector.add((DEREncodable)DERGeneralString.valueOf((String)it.next()));
        }
        return vector;
    }

    private static List<String> getNameStrings(PrincipalName name) {
        String[] components = name.getNameComponent().split(COMPONENT_SEPARATOR);
        return Arrays.asList(components);
    }
}

