/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncryptionType
implements Comparable<EncryptionType> {
    public static final EncryptionType UNKNOWN = new EncryptionType(-1, "UNKNOWN");
    public static final EncryptionType NULL = new EncryptionType(0, "NULL");
    public static final EncryptionType DES_CBC_CRC = new EncryptionType(1, "des-cbc-crc");
    public static final EncryptionType DES_CBC_MD4 = new EncryptionType(2, "des-cbc-md4");
    public static final EncryptionType DES_CBC_MD5 = new EncryptionType(3, "des-cbc-md5");
    public static final EncryptionType RESERVED4 = new EncryptionType(4, "[reserved]");
    public static final EncryptionType DES3_CBC_MD5 = new EncryptionType(5, "des3-cbc-md5");
    public static final EncryptionType RESERVED6 = new EncryptionType(6, "[reserved]");
    public static final EncryptionType DES3_CBC_SHA1 = new EncryptionType(7, "des3-cbc-sha1");
    public static final EncryptionType ID_DSA_WITH_SHA1_CMSOID = new EncryptionType(9, "id-dsa-with-sha1-CmsOID");
    public static final EncryptionType MD5WITHRSAENCRYPTION_CMSOID = new EncryptionType(10, "md5WithRSAEncryption-CmsOID");
    public static final EncryptionType SHA_1WITHRSAENCRYPTION_CMSOID = new EncryptionType(11, "sha-1WithRSAEncryption-CmsOID");
    public static final EncryptionType RC2_CBC_ENVOID = new EncryptionType(12, "rc2-cbc-EnvOID");
    public static final EncryptionType RSAENCRYPTION_ENVOID = new EncryptionType(13, "rsaEncryption-EnvOID");
    public static final EncryptionType ID_RSAES_OAEP_ENVOID = new EncryptionType(14, "id-RSAES-OAEP-EnvOID");
    public static final EncryptionType DES_EDE3_CBC_ENVOID = new EncryptionType(15, "des-ede3-cbc-EnvOID");
    public static final EncryptionType DES3_CBC_SHA1_KD = new EncryptionType(16, "des3-cbc-sha1-kd");
    public static final EncryptionType AES128_CTS_HMAC_SHA1_96 = new EncryptionType(17, "aes128-cts-hmac-sha1-96");
    public static final EncryptionType AES256_CTS_HMAC_SHA1_96 = new EncryptionType(18, "aes256-cts-hmac-sha1-96");
    public static final EncryptionType RC4_HMAC = new EncryptionType(23, "rc4-hmac");
    public static final EncryptionType RC4_HMAC_EXP = new EncryptionType(24, "rc4-hmac-exp");
    public static final EncryptionType SUBKEY_KEYMATERIAL = new EncryptionType(65, "subkey-keymaterial");
    public static final EncryptionType RC4_MD4 = new EncryptionType(-128, "rc4-md4");
    public static final EncryptionType RC4_HMAC_OLD = new EncryptionType(-133, "rc4-hmac-old");
    public static final EncryptionType RC4_HMAC_OLD_EXP = new EncryptionType(-135, "rc4-hmac-old-exp");
    private static final EncryptionType[] values = new EncryptionType[]{UNKNOWN, NULL, DES_CBC_CRC, DES_CBC_MD4, DES_CBC_MD5, RESERVED4, DES3_CBC_MD5, RESERVED6, DES3_CBC_SHA1, ID_DSA_WITH_SHA1_CMSOID, MD5WITHRSAENCRYPTION_CMSOID, SHA_1WITHRSAENCRYPTION_CMSOID, RC2_CBC_ENVOID, RSAENCRYPTION_ENVOID, ID_RSAES_OAEP_ENVOID, DES_EDE3_CBC_ENVOID, DES3_CBC_SHA1_KD, AES128_CTS_HMAC_SHA1_96, AES256_CTS_HMAC_SHA1_96, RC4_HMAC, RC4_HMAC_EXP, SUBKEY_KEYMATERIAL, RC4_MD4, RC4_HMAC_OLD, RC4_HMAC_OLD_EXP};
    public static final List<EncryptionType> VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private EncryptionType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public static EncryptionType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (EncryptionType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return UNKNOWN;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(EncryptionType that) {
        return this.ordinal - that.ordinal;
    }

    public String toString() {
        return this.name + " (" + this.ordinal + ")";
    }
}

