/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.io.services.enricher;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.io.services.enricher.AbstractContentEnricher;
import org.nuxeo.ecm.automation.io.services.enricher.RestEvaluationContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

public class UserPermissionsContentEnricher
extends AbstractContentEnricher {
    private static final String PERMISSIONS_PARAMETER = "permissions";
    public static final String PERMISSIONS_CONTENT_ID = "permissions";
    private List<String> availablePermissions = new ArrayList<String>();

    @Override
    public void enrich(JsonGenerator jg, RestEvaluationContext ec) throws ClientException, IOException {
        DocumentModel doc = ec.getDocumentModel();
        jg.writeStartArray();
        for (String permission : this.getPermissions(doc)) {
            jg.writeString(permission);
        }
        jg.writeEndArray();
        jg.flush();
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        String permissionsList = parameters.get("permissions");
        if (permissionsList != null) {
            this.availablePermissions.addAll(Arrays.asList(permissionsList.split(",")));
        }
    }

    private Iterable<String> getPermissions(final DocumentModel doc) {
        final CoreSession session = doc.getCoreSession();
        final Principal principal = session.getPrincipal();
        return Iterables.filter(this.availablePermissions, (Predicate)new Predicate<String>(){

            public boolean apply(String permission) {
                return session.hasPermission(principal, doc.getRef(), permission);
            }
        });
    }
}

