/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api.adapters;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;

public class PictureBookBlobHolder
extends DocumentBlobHolder {
    private CoreSession session;

    public PictureBookBlobHolder(DocumentModel doc, String xPath) {
        super(doc, xPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob() throws ClientException {
        CoreSession session = this.getSession();
        boolean sessionOpened = false;
        if (session == null) {
            sessionOpened = true;
            session = CoreInstance.openCoreSession((String)this.doc.getRepositoryName());
        }
        try {
            DocumentModelList docs = session.getChildren(this.doc.getRef(), "Picture");
            if (docs.isEmpty()) {
                Blob blob = null;
                return blob;
            }
            DocumentModel documentModel = (DocumentModel)docs.get(0);
            if (documentModel == null) {
                Blob blob = null;
                return blob;
            }
            PictureResourceAdapter picture = (PictureResourceAdapter)documentModel.getAdapter(PictureResourceAdapter.class);
            Blob blob = picture.getPictureFromTitle("Original");
            return blob;
        }
        finally {
            if (sessionOpened) {
                session.close();
            }
        }
    }

    public List<Blob> getBlobs() throws ClientException {
        return this.getBlobs("Original");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Blob> getBlobs(String title) throws ClientException {
        CoreSession session = this.getSession();
        boolean sessionOpened = false;
        if (session == null) {
            sessionOpened = true;
            session = CoreInstance.openCoreSession((String)this.doc.getRepositoryName());
        }
        try {
            DocumentModelList docList = session.getChildren(this.doc.getRef(), "Picture");
            ArrayList<Blob> blobList = new ArrayList<Blob>(docList.size());
            for (DocumentModel documentModel : docList) {
                PictureResourceAdapter picture = (PictureResourceAdapter)documentModel.getAdapter(PictureResourceAdapter.class);
                blobList.add(picture.getPictureFromTitle(title));
            }
            ArrayList<Blob> arrayList = blobList;
            return arrayList;
        }
        finally {
            if (sessionOpened) {
                session.close();
            }
        }
    }

    public String getHash() throws ClientException {
        String h;
        Blob blob = this.getBlob();
        if (blob != null && (h = blob.getDigest()) != null) {
            return h;
        }
        return this.doc.getId() + this.xPath + this.getModificationDate().toString();
    }

    protected CoreSession getSession() throws ClientException {
        if (this.session == null && this.doc != null) {
            this.session = this.doc.getCoreSession();
        }
        return this.session;
    }
}

