/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.JoinRowSet;
import javax.sql.rowset.Joinable;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleJDBCRowSet;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleWebRowSet;

public class OracleJoinRowSet
extends OracleWebRowSet
implements JoinRowSet {
    private static final String MATCH_COLUMN_SUFFIX = "#MATCH_COLUMN";
    private static boolean[] supportedJoins = new boolean[]{false, true, false, false, false};
    private int joinType = 1;
    private Vector addedRowSets = new Vector();
    private Vector addedRowSetNames = new Vector();
    private Object lockForJoinActions;

    public synchronized void addRowSet(Joinable joinable) throws SQLException {
        if (joinable == null) {
            throw new SQLException("Invalid empty RowSet parameter");
        }
        if (!(joinable instanceof RowSet)) {
            throw new SQLException("The parameter is not a RowSet instance");
        }
        OracleCachedRowSet oracleCachedRowSet = this.checkAndWrapRowSet((RowSet)((Object)joinable));
        String string = this.getMatchColumnTableName((RowSet)((Object)joinable));
        switch (this.joinType) {
            case 1: {
                this.doInnerJoin(oracleCachedRowSet);
                this.addedRowSets.add(joinable);
                this.addedRowSetNames.add(string);
                break;
            }
            default: {
                throw new SQLException("Join type is not supported");
            }
        }
    }

    public synchronized void addRowSet(RowSet rowSet, int n) throws SQLException {
        ((OracleRowSet)((Object)rowSet)).setMatchColumn(n);
        this.addRowSet((Joinable)((Object)rowSet));
    }

    public synchronized void addRowSet(RowSet rowSet, String string) throws SQLException {
        ((OracleRowSet)((Object)rowSet)).setMatchColumn(string);
        this.addRowSet((Joinable)((Object)rowSet));
    }

    public synchronized void addRowSet(RowSet[] rowSetArray, int[] nArray) throws SQLException {
        if (rowSetArray.length != nArray.length) {
            throw new SQLException("Number of elements in rowsets is not equal to match columns");
        }
        for (int i = 0; i < rowSetArray.length; ++i) {
            ((OracleRowSet)((Object)rowSetArray[i])).setMatchColumn(nArray[i]);
            this.addRowSet((Joinable)((Object)rowSetArray[i]));
        }
    }

    public synchronized void addRowSet(RowSet[] rowSetArray, String[] stringArray) throws SQLException {
        if (rowSetArray.length != stringArray.length) {
            throw new SQLException("Number of elements in rowsets is not equal to match columns");
        }
        for (int i = 0; i < rowSetArray.length; ++i) {
            ((OracleRowSet)((Object)rowSetArray[i])).setMatchColumn(stringArray[i]);
            this.addRowSet((Joinable)((Object)rowSetArray[i]));
        }
    }

    public Collection getRowSets() throws SQLException {
        return this.addedRowSets;
    }

    public String[] getRowSetNames() throws SQLException {
        Object[] objectArray = this.addedRowSetNames.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public CachedRowSet toCachedRowSet() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createCopy();
        oracleCachedRowSet.setCommand("");
        return oracleCachedRowSet;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public boolean supportsCrossJoin() {
        return supportedJoins[0];
    }

    public boolean supportsInnerJoin() {
        return supportedJoins[1];
    }

    public boolean supportsLeftOuterJoin() {
        return supportedJoins[2];
    }

    public boolean supportsRightOuterJoin() {
        return supportedJoins[3];
    }

    public boolean supportsFullJoin() {
        return supportedJoins[4];
    }

    public void setJoinType(int n) throws SQLException {
        if (n != 1) {
            throw new SQLException("Join type is not supported");
        }
        this.joinType = n;
    }

    public synchronized String getWhereClause() throws SQLException {
        if (this.addedRowSets.size() < 2) {
            return "WHERE";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE\n");
        OracleRowSet oracleRowSet = (OracleRowSet)this.addedRowSets.get(0);
        int[] nArray = oracleRowSet.getMatchColumnIndexes();
        ResultSetMetaData resultSetMetaData = oracleRowSet.getMetaData();
        String string = oracleRowSet.getTableName();
        for (int i = 1; i < this.addedRowSets.size(); ++i) {
            if (i > 1) {
                stringBuffer.append("\nAND\n");
            }
            OracleRowSet oracleRowSet2 = (OracleRowSet)this.addedRowSets.get(i);
            int[] nArray2 = oracleRowSet2.getMatchColumnIndexes();
            ResultSetMetaData resultSetMetaData2 = oracleRowSet2.getMetaData();
            String string2 = oracleRowSet2.getTableName();
            for (int j = 0; j < nArray.length; ++j) {
                if (j > 0) {
                    stringBuffer.append("\nAND\n");
                }
                stringBuffer.append("(" + string + "." + resultSetMetaData.getColumnName(nArray[j]) + " = " + string2 + "." + resultSetMetaData2.getColumnName(nArray2[j]) + ")");
            }
            oracleRowSet = oracleRowSet2;
            nArray = nArray2;
            resultSetMetaData = resultSetMetaData2;
            string = string2;
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private void doInnerJoin(OracleCachedRowSet oracleCachedRowSet) throws SQLException {
        if (this.addedRowSets.isEmpty()) {
            this.setMetaData((RowSetMetaData)oracleCachedRowSet.getMetaData());
            this.populate(oracleCachedRowSet);
            this.setMatchColumn(oracleCachedRowSet.getMatchColumnIndexes());
        } else {
            int n;
            int n2;
            int n3;
            boolean bl;
            Vector<OracleRow> vector = new Vector<OracleRow>(100);
            OracleRowSetMetaData oracleRowSetMetaData = new OracleRowSetMetaData(10);
            int[] nArray = this.getMatchColumnIndexes();
            int[] nArray2 = oracleCachedRowSet.getMatchColumnIndexes();
            int n4 = this.getMetaData().getColumnCount() + oracleCachedRowSet.getMetaData().getColumnCount() - nArray2.length;
            oracleRowSetMetaData.setColumnCount(n4);
            String string = this.getTableName() + "#" + oracleCachedRowSet.getTableName();
            for (int i = 1; i <= this.colCount; ++i) {
                bl = false;
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    if (i != nArray[n3]) continue;
                    bl = true;
                    break;
                }
                this.setNewColumnMetaData(i, oracleRowSetMetaData, i, (RowSetMetaData)this.rowsetMetaData, bl, string);
            }
            RowSetMetaData rowSetMetaData = (RowSetMetaData)oracleCachedRowSet.getMetaData();
            n3 = rowSetMetaData.getColumnCount();
            int n5 = this.colCount + 1;
            int[] nArray3 = new int[n3];
            for (n2 = 1; n2 <= n3; ++n2) {
                bl = false;
                for (n = 0; n < nArray2.length; ++n) {
                    if (n2 != nArray[n]) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.setNewColumnMetaData(n5, oracleRowSetMetaData, n2, rowSetMetaData, bl, string);
                    nArray3[n2 - 1] = n5++;
                    continue;
                }
                nArray3[n2 - 1] = -1;
            }
            this.beforeFirst();
            n2 = oracleCachedRowSet.size();
            n = 0;
            for (int i = 1; i <= this.rowCount; ++i) {
                this.next();
                oracleCachedRowSet.beforeFirst();
                for (int j = 1; j <= n2; ++j) {
                    int n6;
                    oracleCachedRowSet.next();
                    n = 1;
                    for (int k = 0; k < nArray.length; ++k) {
                        Object object;
                        Object object2 = this.getObject(nArray[k]);
                        if (object2.equals(object = oracleCachedRowSet.getObject(nArray2[k]))) continue;
                        n = 0;
                        break;
                    }
                    if (n == 0) continue;
                    OracleRow oracleRow = new OracleRow(n4, true);
                    for (n6 = 1; n6 <= this.colCount; ++n6) {
                        oracleRow.updateObject(n6, this.getObject(n6));
                    }
                    for (n6 = 1; n6 <= n3; ++n6) {
                        if (nArray3[n6 - 1] == -1) continue;
                        oracleRow.updateObject(nArray3[n6 - 1], oracleCachedRowSet.getObject(n6));
                    }
                    vector.add(oracleRow);
                }
            }
            this.rows = vector;
            this.presentRow = 0;
            this.rowCount = this.rows.size();
            this.setMetaData(oracleRowSetMetaData);
        }
    }

    private void setNewColumnMetaData(int n, RowSetMetaData rowSetMetaData, int n2, RowSetMetaData rowSetMetaData2, boolean bl, String string) throws SQLException {
        rowSetMetaData.setAutoIncrement(n, rowSetMetaData2.isAutoIncrement(n2));
        rowSetMetaData.setCaseSensitive(n, rowSetMetaData2.isCaseSensitive(n2));
        rowSetMetaData.setCatalogName(n, rowSetMetaData2.getCatalogName(n2));
        rowSetMetaData.setColumnDisplaySize(n, rowSetMetaData2.getColumnDisplaySize(n2));
        if (bl) {
            rowSetMetaData.setColumnName(n, rowSetMetaData2.getColumnName(n) + MATCH_COLUMN_SUFFIX);
        } else {
            rowSetMetaData.setColumnName(n, rowSetMetaData2.getColumnName(n2));
        }
        rowSetMetaData.setColumnLabel(n, rowSetMetaData.getColumnName(n2));
        rowSetMetaData.setColumnType(n, rowSetMetaData2.getColumnType(n2));
        rowSetMetaData.setColumnTypeName(n, rowSetMetaData2.getColumnTypeName(n2));
        rowSetMetaData.setCurrency(n, rowSetMetaData2.isCurrency(n2));
        rowSetMetaData.setNullable(n, rowSetMetaData2.isNullable(n2));
        rowSetMetaData.setPrecision(n, rowSetMetaData2.getPrecision(n2));
        rowSetMetaData.setScale(n, rowSetMetaData2.getScale(n2));
        rowSetMetaData.setSchemaName(n, rowSetMetaData2.getSchemaName(n2));
        rowSetMetaData.setSearchable(n, rowSetMetaData2.isSearchable(n2));
        rowSetMetaData.setSigned(n, rowSetMetaData2.isSigned(n2));
        if (bl) {
            rowSetMetaData.setTableName(n, string);
        } else {
            rowSetMetaData.setTableName(n, rowSetMetaData2.getTableName(n2));
        }
    }

    private OracleCachedRowSet checkAndWrapRowSet(RowSet rowSet) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        if (rowSet instanceof OracleCachedRowSet) {
            oracleCachedRowSet = (OracleCachedRowSet)rowSet;
        } else if (rowSet instanceof OracleJDBCRowSet) {
            oracleCachedRowSet = new OracleCachedRowSet();
            oracleCachedRowSet.populate(rowSet);
            int[] nArray = ((OracleJDBCRowSet)rowSet).getMatchColumnIndexes();
            oracleCachedRowSet.setMatchColumn(nArray);
        } else {
            throw new SQLException("Third-party RowSet Join not yet supported");
        }
        return oracleCachedRowSet;
    }

    private String getMatchColumnTableName(RowSet rowSet) throws SQLException {
        String string = null;
        if (rowSet instanceof OracleRowSet) {
            string = ((OracleRowSet)((Object)rowSet)).getTableName();
        }
        return string;
    }
}

