/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.service.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.runtime.service.proxy.AdaptableServiceInvoker;
import org.nuxeo.runtime.service.proxy.MethodInvocation;

public class ServiceAdapterInvoker
implements InvocationHandler {
    protected static final ConcurrentHashMap<Method, Method> methods = new ConcurrentHashMap();
    protected final AdaptableServiceInvoker<?> invoker;

    public ServiceAdapterInvoker(AdaptableServiceInvoker<?> remote) {
        this.invoker = remote;
    }

    public AdaptableServiceInvoker<?> getServiceInvoker() {
        return this.invoker;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodInvocation invocation = new MethodInvocation(method);
        try {
            return this.invoker.getRemote().invokeAdapter(invocation, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                AdaptableServiceInvoker.handleException(cause);
            } else {
                AdaptableServiceInvoker.handleException(e);
            }
            throw e;
        }
        catch (Throwable t) {
            AdaptableServiceInvoker.handleException(t);
            throw t;
        }
    }
}

