/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mockito;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.runtime.api.DefaultServiceProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceProvider;

public class MockProvider
implements ServiceProvider {
    protected ServiceProvider next;
    protected final Map<Class<?>, Object> mocks = new HashMap();

    public void bind(Class<?> klass, Object mock) {
        this.mocks.put(klass, mock);
    }

    public void clearBindings() {
        this.mocks.clear();
    }

    public void installSelf() {
        this.next = DefaultServiceProvider.getProvider();
        DefaultServiceProvider.setProvider((ServiceProvider)this);
    }

    public void uninstallSelf() {
        DefaultServiceProvider.setProvider((ServiceProvider)this.next);
        this.next = null;
    }

    public <T> T getService(Class<T> serviceClass) {
        if (this.mocks.containsKey(serviceClass)) {
            return serviceClass.cast(this.mocks.get(serviceClass));
        }
        if (this.next != null) {
            return (T)this.next.getService(serviceClass);
        }
        return (T)Framework.getRuntime().getService(serviceClass);
    }
}

