/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.jboss.seam.remoting.wrapper.BaseWrapper;
import org.jboss.seam.remoting.wrapper.ConversionException;
import org.jboss.seam.remoting.wrapper.ConversionScore;
import org.jboss.seam.remoting.wrapper.Wrapper;

public class MapWrapper
extends BaseWrapper
implements Wrapper {
    private static final byte[] MAP_TAG_OPEN = "<map>".getBytes();
    private static final byte[] MAP_TAG_CLOSE = "</map>".getBytes();
    private static final byte[] ELEMENT_TAG_OPEN = "<element>".getBytes();
    private static final byte[] ELEMENT_TAG_CLOSE = "</element>".getBytes();
    private static final byte[] KEY_TAG_OPEN = "<k>".getBytes();
    private static final byte[] KEY_TAG_CLOSE = "</k>".getBytes();
    private static final byte[] VALUE_TAG_OPEN = "<v>".getBytes();
    private static final byte[] VALUE_TAG_CLOSE = "</v>".getBytes();

    @Override
    public void marshal(OutputStream out) throws IOException {
        out.write(MAP_TAG_OPEN);
        Map m = (Map)this.value;
        for (Object key : m.keySet()) {
            out.write(ELEMENT_TAG_OPEN);
            out.write(KEY_TAG_OPEN);
            this.context.createWrapperFromObject(key, String.format("%s[key]", this.path)).marshal(out);
            out.write(KEY_TAG_CLOSE);
            out.write(VALUE_TAG_OPEN);
            this.context.createWrapperFromObject(m.get(key), String.format("%s[value]", this.path)).marshal(out);
            out.write(VALUE_TAG_CLOSE);
            out.write(ELEMENT_TAG_CLOSE);
        }
        out.write(MAP_TAG_CLOSE);
    }

    @Override
    public Object convert(Type type) throws ConversionException {
        if (this.context == null) {
            throw new IllegalStateException("No call context has been set");
        }
        Class typeClass = null;
        Object keyType = null;
        Object valueType = null;
        if (type instanceof ParameterizedType && Map.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) {
            typeClass = (Class)((ParameterizedType)type).getRawType();
            for (Type t : ((ParameterizedType)type).getActualTypeArguments()) {
                if (keyType != null) {
                    valueType = t;
                    break;
                }
                keyType = t;
            }
        } else if (type instanceof Class && Map.class.isAssignableFrom((Class)type)) {
            if (!((Class)type).isInterface()) {
                typeClass = (Class)type;
            }
            keyType = Object.class;
            valueType = Object.class;
        } else {
            throw new ConversionException(String.format("Cannot convert value to type [%s]", type));
        }
        if (typeClass == null || typeClass.isInterface()) {
            this.value = new HashMap();
        } else {
            try {
                if (type instanceof Class) {
                    this.value = ((Class)type).newInstance();
                } else if (type instanceof ParameterizedType) {
                    this.value = ((Class)((ParameterizedType)type).getRawType()).newInstance();
                }
            }
            catch (Exception ex) {
                throw new ConversionException(String.format("Could not create value of type [%s]", type));
            }
        }
        for (Element e : this.element.elements("element")) {
            Element keyElement = (Element)e.element("k").elementIterator().next();
            Element valueElement = (Element)e.element("v").elementIterator().next();
            ((Map)this.value).put(this.context.createWrapperFromElement(keyElement).convert((Type)keyType), this.context.createWrapperFromElement(valueElement).convert((Type)valueType));
        }
        return this.value;
    }

    @Override
    public ConversionScore conversionScore(Class cls) {
        if (Map.class.isAssignableFrom(cls)) {
            return ConversionScore.exact;
        }
        if (cls.equals(Object.class)) {
            return ConversionScore.compatible;
        }
        return ConversionScore.nomatch;
    }
}

