/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.we;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.client.we.RequestHelper;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="downloadHandler")
public class DownloadHandler
extends DefaultObject {
    protected static final Log log = LogFactory.getLog(DownloadHandler.class);

    @GET
    @Produces(value={"text/plain"})
    @Path(value="progress/{pkgId}")
    public String getDownloadProgress(@PathParam(value="pkgId") String pkgId) {
        DownloadingPackage pkg = this.getDownloadingPackage(pkgId);
        if (pkg == null) {
            return null;
        }
        return pkg.getDownloadProgress() + "";
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="progressAsJSON")
    public String getDownloadsProgress() {
        ConnectDownloadManager cdm = (ConnectDownloadManager)Framework.getLocalService(ConnectDownloadManager.class);
        List pkgs = cdm.listDownloadingPackages();
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < pkgs.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("{ \"pkgid\" : ");
            sb.append("\"" + ((DownloadingPackage)pkgs.get(i)).getId() + "\",");
            sb.append(" \"progress\" : ");
            sb.append(((DownloadingPackage)pkgs.get(i)).getDownloadProgress() + "}");
        }
        sb.append("]");
        return sb.toString();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="progressPage/{pkgId}")
    public Object getDownloadProgressPage(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source, @QueryParam(value="install") Boolean install, @QueryParam(value="depCheck") Boolean depCheck, @QueryParam(value="type") String pkgType, @QueryParam(value="onlyRemote") Boolean onlyRemote, @QueryParam(value="filterOnPlatform") Boolean filterOnPlatform) {
        PackageManager pm;
        DownloadingPackage pkg = this.getDownloadingPackage(pkgId);
        boolean downloadOver = false;
        if (install == null) {
            install = false;
        }
        if (depCheck == null) {
            depCheck = true;
        }
        if (pkg == null && (pkg = (pm = (PackageManager)Framework.getLocalService(PackageManager.class)).getPackage(pkgId)).getPackageState() != PackageState.DOWNLOADING) {
            downloadOver = true;
        }
        return this.getView("downloadStarted").arg("pkg", (Object)pkg).arg("source", (Object)source).arg("over", (Object)downloadOver).arg("install", (Object)install).arg("depCheck", (Object)depCheck).arg("filterOnPlatform", (Object)filterOnPlatform.toString()).arg("type", (Object)pkgType.toString()).arg("onlyRemote", (Object)onlyRemote.toString());
    }

    protected DownloadingPackage getDownloadingPackage(String pkgId) {
        ConnectDownloadManager cdm = (ConnectDownloadManager)Framework.getLocalService(ConnectDownloadManager.class);
        List pkgs = cdm.listDownloadingPackages();
        for (DownloadingPackage pkg : pkgs) {
            if (!pkg.getId().equals(pkgId)) continue;
            return pkg;
        }
        return null;
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="start/{pkgId}")
    public Object startDownload(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source, @QueryParam(value="install") Boolean install, @QueryParam(value="depCheck") Boolean depCheck, @QueryParam(value="type") String pkgType, @QueryParam(value="onlyRemote") Boolean onlyRemote, @QueryParam(value="filterOnPlatform") Boolean filterOnPlatform) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        if (install == null) {
            install = false;
        }
        if (depCheck == null) {
            depCheck = true;
        }
        if (!RequestHelper.isInternalLink(this.getContext())) {
            DownloadablePackage pkg = pm.getPackage(pkgId);
            return this.getView("confirmDownload").arg("pkg", (Object)pkg).arg("source", (Object)source);
        }
        try {
            pm.download(pkgId);
        }
        catch (ConnectServerError e) {
            return this.getView("downloadError").arg("e", (Object)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.getView("downloadStarted").arg("pkg", (Object)this.getDownloadingPackage(pkgId)).arg("source", (Object)source).arg("over", (Object)false).arg("install", (Object)install).arg("depCheck", (Object)depCheck).arg("filterOnPlatform", (Object)filterOnPlatform.toString()).arg("type", (Object)pkgType.toString()).arg("onlyRemote", (Object)onlyRemote.toString());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="startDownloads")
    public String startDownloads(@QueryParam(value="pkgList") String pkgList) {
        if (RequestHelper.isInternalLink(this.getContext()) && pkgList != null) {
            Object[] pkgs = pkgList.split("/");
            PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
            try {
                log.info((Object)("Starting download for packages " + Arrays.toString(pkgs)));
                pm.download(Arrays.asList(pkgs));
            }
            catch (ConnectServerError e) {
                log.error((Object)e, (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            for (int i = 0; i < pkgs.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("{ \"pkgid\" : ");
                sb.append("\"" + (String)pkgs[i] + "\",");
                sb.append(" \"progress\" : 0}");
            }
            sb.append("]");
            return sb.toString();
        }
        return "[]";
    }

    @GET
    @Path(value="cancel/{pkgId}")
    public Object cancelDownload(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        pm.cancelDownload(pkgId);
        return this.redirect(this.getPrevious().getPath() + "/packages/" + source);
    }
}

