/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BinaryProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BooleanProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.DateProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.DoubleProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.ExternalBlobProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.LongProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.StringProperty;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;

public class PropertyFactory {
    private PropertyFactory() {
    }

    public static Property createProperty(Property parent, Field field, int flags) {
        Type type = field.getType();
        if (type instanceof SimpleTypeImpl) {
            type = type.getSuperType();
        }
        switch (type.getName()) {
            case "string": {
                return new StringProperty(parent, field, flags);
            }
            case "integer": 
            case "long": {
                return new LongProperty(parent, field, flags);
            }
            case "double": {
                return new DoubleProperty(parent, field, flags);
            }
            case "boolean": {
                return new BooleanProperty(parent, field, flags);
            }
            case "date": {
                return new DateProperty(parent, field, flags);
            }
            case "binary": {
                return new BinaryProperty(parent, field, flags);
            }
            case "content": {
                return new BlobProperty(parent, field, flags);
            }
            case "externalcontent": {
                return new ExternalBlobProperty(parent, field, flags);
            }
        }
        if (type.isSimpleType()) {
            return new ScalarProperty(parent, field, flags);
        }
        if (type.isComplexType()) {
            return new MapProperty(parent, field, flags);
        }
        if (type.isListType()) {
            if (((ListType)type).isArray()) {
                return new ArrayProperty(parent, field, flags);
            }
            return new ListProperty(parent, field, flags);
        }
        throw new IllegalArgumentException("Unsupported field type: " + field.getType().getName());
    }
}

