/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;

public class DocumentModelChildrenIterator
implements DocumentModelIterator {
    private static final Log log = LogFactory.getLog(DocumentModelChildrenIterator.class);
    private CoreSession session;
    private String type;
    private Filter filter;
    private Iterator<String> it;
    private DocumentModel next;

    public DocumentModelChildrenIterator(CoreSession session, DocumentRef parentRef, String type, Filter filter) throws ClientException {
        this.session = session;
        this.type = type;
        this.filter = filter;
        List<DocumentRef> refs = session.getChildrenRefs(parentRef, null);
        ArrayList<String> ids = new ArrayList<String>(refs.size());
        for (DocumentRef ref : refs) {
            ids.add(ref.toString());
        }
        this.it = ids.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.it.hasNext()) {
            String id = this.it.next();
            try {
                DocumentModel doc = this.session.getDocument(new IdRef(id));
                if (!this.accept(doc)) continue;
                this.next = doc;
                return true;
            }
            catch (ClientException e) {
                log.error((Object)"Error retrieving next element", (Throwable)e);
                continue;
            }
            break;
        }
        return false;
    }

    private boolean accept(DocumentModel doc) {
        if (this.type != null && !this.type.equals(doc.getType())) {
            return false;
        }
        return this.filter == null || this.filter.accept(doc);
    }

    @Override
    public DocumentModel next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DocumentModel res = this.next;
        this.next = null;
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<DocumentModel> iterator() {
        return this;
    }

    @Override
    public long size() {
        return -1L;
    }
}

