/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.tests;

import java.net.URI;
import java.util.EventListener;
import javax.servlet.Servlet;
import org.apache.chemistry.opencmis.server.shared.BasicAuthCallContextHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.nuxeo.ecm.core.opencmis.bindings.NuxeoCmisAtomPubServlet;
import org.nuxeo.ecm.core.opencmis.bindings.NuxeoCmisContextListener;
import org.nuxeo.ecm.core.opencmis.tests.Helper;
import org.nuxeo.ecm.core.storage.sql.SQLRepositoryTestCase;

public class MainWithServlet
extends SQLRepositoryTestCase {
    private static final Log log = LogFactory.getLog(MainWithServlet.class);
    public static final String PARAM_CALL_CONTEXT_HANDLER = "callContextHandler";
    public static final String HOST = "localhost";
    public static final int PORT = 17480;
    public static final int WAIT_MINUTES = 60;
    public Server server;
    public URI serverURI;

    public static void main(String[] args) throws Exception {
        new MainWithServlet().intanceMain(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intanceMain(String[] args) throws Exception {
        this.setUp();
        try {
            Thread.sleep(3600000L);
        }
        finally {
            this.tearDown();
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        this.openSession();
        Helper.makeNuxeoRepository(this.session);
        this.database.sleepForFulltext();
        this.closeSession();
        log.warn((Object)"CMIS repository starting...");
        this.setUpServer();
        log.warn((Object)("CMIS repository started, AtomPub service url: " + this.serverURI));
    }

    public void tearDown() throws Exception {
        this.tearDownServer();
        super.tearDown();
    }

    protected void setUpServer() throws Exception {
        this.server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setHost(HOST);
        connector.setPort(17480);
        this.server.addConnector((Connector)connector);
        Context context = new Context((HandlerContainer)this.server, "/", 1);
        this.setUpContext(context);
        context.setEventListeners(this.getEventListeners());
        ServletHolder holder = new ServletHolder(this.getServlet());
        holder.setInitParameter(PARAM_CALL_CONTEXT_HANDLER, BasicAuthCallContextHandler.class.getName());
        context.addServlet(holder, "/*");
        this.serverURI = new URI("http://localhost:17480/");
        this.server.start();
    }

    protected void tearDownServer() throws Exception {
        log.warn((Object)"CMIS repository stopping...");
        this.server.stop();
        this.server.join();
        this.server = null;
        log.warn((Object)"CMIS repository stopped");
    }

    protected void setUpContext(Context context) throws Exception {
    }

    protected Servlet getServlet() {
        return new NuxeoCmisAtomPubServlet();
    }

    protected EventListener[] getEventListeners() {
        return new EventListener[]{new NuxeoCmisContextListener()};
    }
}

