/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.Serializable;
import javax.inject.Named;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CacheFeature.class})
public class CacheComplianceFixture {
    @Inject
    @Named(value="default-test-cache")
    Cache defaultCache;

    @Test
    public void getValue() throws IOException {
        String cachedVal = (String)((Object)this.defaultCache.get("key1"));
        junit.framework.Assert.assertEquals((String)"val1", (String)cachedVal);
    }

    @Test
    public void keyNotExist() throws IOException {
        junit.framework.Assert.assertNull((Object)this.defaultCache.get("key-not-exist"));
    }

    @Test
    public void putUpdateGet() throws IOException {
        String val2 = "val2";
        this.defaultCache.put("key1", (Serializable)((Object)val2));
        val2 = (String)((Object)this.defaultCache.get("key1"));
        junit.framework.Assert.assertEquals((String)"val2", (String)val2);
    }

    @Test
    public void putNullKey() throws IOException {
        try {
            this.defaultCache.put(null, (Serializable)((Object)"val-null"));
            Assert.fail((String)"Should raise exception !");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void putNullValue() throws Exception {
        try {
            this.defaultCache.put("key-null", null);
            Assert.fail((String)"Should raise exception !");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    @Ignore
    public void ttlExpire() throws InterruptedException, IOException {
        Thread.sleep(61000L);
        String expiredVal = (String)((Object)this.defaultCache.get("key1"));
        junit.framework.Assert.assertNull((Object)expiredVal);
    }

    @Test
    public void invalidateKey() throws IOException {
        junit.framework.Assert.assertNotNull((Object)this.defaultCache.get("key1"));
        this.defaultCache.invalidate("key1");
        junit.framework.Assert.assertNull((Object)this.defaultCache.get("key1"));
    }

    @Test
    public void invalidateAll() throws IOException {
        junit.framework.Assert.assertNotNull((Object)this.defaultCache.get("key1"));
        this.defaultCache.put("key2", (Serializable)((Object)"val2"));
        junit.framework.Assert.assertNotNull((Object)this.defaultCache.get("key2"));
        this.defaultCache.invalidateAll();
        junit.framework.Assert.assertNull((Object)this.defaultCache.get("key1"));
        junit.framework.Assert.assertNull((Object)this.defaultCache.get("key2"));
    }
}

