/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.template;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import org.nuxeo.ecm.platform.ec.notification.email.templates.NuxeoTemplatesLoader;
import org.nuxeo.ecm.platform.rendering.RenderingContext;
import org.nuxeo.ecm.platform.rendering.RenderingEngine;
import org.nuxeo.ecm.platform.rendering.RenderingException;
import org.nuxeo.ecm.platform.rendering.RenderingResult;
import org.nuxeo.ecm.platform.rendering.template.FreemarkerRenderingJob;

public abstract class FreemarkerRenderingEngine
implements RenderingEngine {
    protected Configuration cfg;

    public Configuration createConfiguration() throws Exception {
        Configuration config = new Configuration();
        config.setTemplateLoader((TemplateLoader)new NuxeoTemplatesLoader());
        config.setDefaultEncoding("UTF-8");
        config.setClassicCompatible(true);
        return config;
    }

    protected abstract FreemarkerRenderingJob createJob(RenderingContext var1);

    @Override
    public RenderingResult process(RenderingContext ctx) throws RenderingException {
        try {
            if (this.cfg == null) {
                this.cfg = this.createConfiguration();
            }
            FreemarkerRenderingJob job = this.createJob(ctx);
            this.cfg.getTemplate(job.getTemplate(), this.cfg.getDefaultEncoding()).process((Object)ctx, job.getWriter());
            return job.getResult();
        }
        catch (RenderingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RenderingException("Freemarker processing failed", e);
        }
    }
}

