/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.BlobList;

@Operation(id="Context.RestoreBlobsInputFromScript", category="Execution Context", label="Restore input blobs from a script", description="Run a script and return the result Blobs object of the script the output of the operation")
public class RestoreBlobsInputFromScript {
    public static final String ID = "Context.RestoreBlobsInputFromScript";
    @Context
    protected OperationContext ctx;
    @Param(name="script", widget="TextArea")
    protected String script;
    private volatile Expression expr;

    @OperationMethod
    public BlobList run() throws Exception {
        if (this.expr == null) {
            String text = this.script.replaceAll("&lt;", "<");
            text = text.replaceAll("&gt;", ">");
            text = text.replaceAll("&amp;", "&");
            this.expr = Scripting.newExpression(text);
        }
        return (BlobList)this.expr.eval(this.ctx);
    }
}

