/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.Blob;

@Operation(id="Context.RestoreBlobInputFromScript", category="Execution Context", label="Restore input blob from a script", description="Run a script and return the result blob object of the script the output of the operation")
public class RestoreBlobInputFromScript {
    public static final String ID = "Context.RestoreBlobInputFromScript";
    @Context
    protected OperationContext ctx;
    @Param(name="script", widget="TextArea")
    protected String script;
    private volatile Expression expr;

    @OperationMethod
    public Blob run() throws Exception {
        if (this.expr == null) {
            String text = this.script.replaceAll("&lt;", "<");
            text = text.replaceAll("&gt;", ">");
            text = text.replaceAll("&amp;", "&");
            this.expr = Scripting.newExpression(text);
        }
        return (Blob)this.expr.eval(this.ctx);
    }
}

