/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.util;

import java.io.IOException;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.nuxeo.ecm.automation.client.jaxrs.util.BlobDataSource;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.HasFile;

public class MultipartInput
extends MimeMultipart {
    public MultipartInput() {
        super("related");
    }

    public void setRequest(String content) throws IOException {
        MimeBodyPart part = new MimeBodyPart();
        try {
            part.setText(content, "UTF-8");
            part.setContentID("request");
            part.setHeader("Content-Type", "application/json+nxrequest; charset=UTF-8");
            part.setHeader("Content-Transfer-Encoding", "8bit");
            part.setHeader("Content-Length", Integer.toString(content.length()));
            this.addBodyPart((BodyPart)part);
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
    }

    public void setBlob(Blob blob) throws IOException {
        this.setBlob(blob, "input");
    }

    protected void setBlob(Blob blob, String id) throws IOException {
        try {
            MimeBodyPart part = new MimeBodyPart();
            if (blob instanceof HasFile) {
                part.attachFile(((HasFile)((Object)blob)).getFile());
            } else {
                part.setDataHandler(new DataHandler((DataSource)new BlobDataSource(blob)));
                if (blob.getFileName() != null) {
                    part.setFileName(blob.getFileName());
                }
            }
            part.setHeader("Content-Type", blob.getMimeType());
            part.setHeader("Content-Transfer-Encoding", "binary");
            int length = blob.getLength();
            if (length > -1) {
                part.setHeader("Content-Length", Integer.toString(length));
            }
            part.setContentID(id);
            this.addBodyPart((BodyPart)part);
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
    }

    public void setBlobs(List<Blob> blobs) throws IOException {
        int size = blobs.size();
        for (int i = 0; i < size; ++i) {
            this.setBlob(blobs.get(i), "input#" + i);
        }
    }
}

