/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi.auth;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.ws.rs.core.MultivaluedMap;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;
import org.nuxeo.ecm.automation.client.jaxrs.spi.RequestInterceptor;
import org.nuxeo.ecm.automation.client.jaxrs.util.Base64;

public class PortalSSOAuthInterceptor
extends RequestInterceptor {
    protected static final Random RANDOM = new Random();
    protected final String secret;
    protected final String username;

    public PortalSSOAuthInterceptor(String secretKey, String userName) {
        this.secret = secretKey;
        this.username = userName;
    }

    @Override
    public void processRequest(Request request, Connector connector) {
        request.putAll(this.computeHeaders());
    }

    protected Map<String, String> computeHeaders() {
        byte[] hashedToken;
        long ts = new Date().getTime();
        long random = RANDOM.nextInt();
        String clearToken = String.format("%d:%d:%s:%s", ts, random, this.secret, this.username);
        try {
            hashedToken = MessageDigest.getInstance("MD5").digest(clearToken.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot compute token", e);
        }
        String base64HashedToken = Base64.encode(hashedToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("NX_TS", String.valueOf(ts));
        headers.put("NX_RD", String.valueOf(random));
        headers.put("NX_TOKEN", base64HashedToken);
        headers.put("NX_USER", this.username);
        return headers;
    }

    @Override
    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        Map<String, String> computedHeaders = this.computeHeaders();
        MultivaluedMap headers = cr.getHeaders();
        for (Map.Entry<String, String> entry : computedHeaders.entrySet()) {
            headers.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        return this.getNext().handle(cr);
    }
}

