/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.RemoteThrowable;
import org.nuxeo.ecm.automation.client.jaxrs.impl.AutomationClientActivator;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.BooleanMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.DateMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.DocumentMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.DocumentsMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.ExceptionMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.LoginMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.NumberMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.RecordSetMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.spi.marshallers.StringMarshaller;
import org.nuxeo.ecm.automation.client.jaxrs.util.JsonOperationMarshaller;
import org.nuxeo.ecm.automation.client.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.OperationRegistry;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class JsonMarshalling {
    protected static final Log log = LogFactory.getLog(JsonMarshalling.class);
    protected static JsonFactory factory = JsonMarshalling.newJsonFactory();
    protected static final Map<String, JsonMarshaller<?>> marshallersByType = new ConcurrentHashMap();
    protected static final Map<Class<?>, JsonMarshaller<?>> marshallersByJavaType = new ConcurrentHashMap();

    private JsonMarshalling() {
    }

    public static JsonFactory getFactory() {
        return factory;
    }

    public static JsonFactory newJsonFactory() {
        JsonFactory jf = new JsonFactory();
        ObjectMapper oc = new ObjectMapper(jf);
        TypeFactory typeFactoryWithModifier = oc.getTypeFactory().withModifier((TypeModifier)new ThowrableTypeModifier());
        oc.setTypeFactory(typeFactoryWithModifier);
        oc.addHandler(new DeserializationProblemHandler(){

            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException, JsonProcessingException {
                if (deserializer instanceof ThrowableDeserializer) {
                    JsonNode propertyNode = (JsonNode)jp.readValueAsTree();
                    ((ThrowableDeserializer)deserializer).unknownStack.peek().put(propertyName, propertyNode);
                    return true;
                }
                return false;
            }
        });
        SimpleModule module = new SimpleModule("automation", Version.unknownVersion()){

            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.addBeanDeserializerModifier(new BeanDeserializerModifier(){

                    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                        if (!Throwable.class.isAssignableFrom(beanDesc.getBeanClass())) {
                            return super.modifyDeserializer(config, beanDesc, deserializer);
                        }
                        return new ThrowableDeserializer((BeanDeserializer)deserializer);
                    }
                });
            }
        };
        oc.registerModule((Module)module);
        jf.setCodec((ObjectCodec)oc);
        return jf;
    }

    public static void addMarshaller(JsonMarshaller<?> marshaller) {
        marshallersByType.put(marshaller.getType(), marshaller);
        marshallersByJavaType.put(marshaller.getJavaType(), marshaller);
    }

    public static <T> JsonMarshaller<T> getMarshaller(String type) {
        return marshallersByType.get(type);
    }

    public static <T> JsonMarshaller<T> getMarshaller(Class<T> clazz) {
        return marshallersByJavaType.get(clazz);
    }

    public static OperationRegistry readRegistry(String content) throws IOException {
        JsonToken tok;
        HashMap<String, OperationDocumentation> ops = new HashMap<String, OperationDocumentation>();
        HashMap<String, OperationDocumentation> chains = new HashMap<String, OperationDocumentation>();
        HashMap<String, String> paths = new HashMap<String, String>();
        try (JsonParser jp = factory.createParser(content);){
            jp.nextToken();
            tok = jp.nextToken();
            while (tok != null && tok != JsonToken.END_OBJECT) {
                String key = jp.getCurrentName();
                if ("operations".equals(key)) {
                    JsonMarshalling.readOperations(jp, ops);
                } else if ("chains".equals(key)) {
                    JsonMarshalling.readChains(jp, chains);
                } else if ("paths".equals(key)) {
                    JsonMarshalling.readPaths(jp, paths);
                }
                tok = jp.nextToken();
            }
        }
        if (tok == null) {
            throw new IllegalArgumentException("Unexpected end of stream.");
        }
        return new OperationRegistry(paths, ops, chains);
    }

    private static void readOperations(JsonParser jp, Map<String, OperationDocumentation> ops) throws IOException {
        jp.nextToken();
        JsonToken tok = jp.nextToken();
        while (tok != null && tok != JsonToken.END_ARRAY) {
            OperationDocumentation op = JsonOperationMarshaller.read(jp);
            ops.put(op.id, op);
            if (op.aliases != null) {
                for (String alias : op.aliases) {
                    ops.put(alias, op);
                }
            }
            tok = jp.nextToken();
        }
    }

    private static void readChains(JsonParser jp, Map<String, OperationDocumentation> chains) throws IOException {
        jp.nextToken();
        JsonToken tok = jp.nextToken();
        while (tok != null && tok != JsonToken.END_ARRAY) {
            OperationDocumentation op = JsonOperationMarshaller.read(jp);
            chains.put(op.id, op);
            tok = jp.nextToken();
        }
    }

    private static void readPaths(JsonParser jp, Map<String, String> paths) throws IOException {
        jp.nextToken();
        JsonToken tok = jp.nextToken();
        while (tok != null && tok != JsonToken.END_OBJECT) {
            jp.nextToken();
            paths.put(jp.getCurrentName(), jp.getText());
            tok = jp.nextToken();
        }
        if (tok == null) {
            throw new IllegalArgumentException("Unexpected end of stream.");
        }
    }

    /*
     * Loose catch block
     */
    public static Object readEntity(String content) throws IOException {
        if (content.length() == 0) {
            return null;
        }
        Throwable throwable = null;
        try (JsonParser jp = factory.createParser(content);){
            JsonMarshaller jm;
            block36: {
                jp.nextToken();
                jp.nextToken();
                if (!"entity-type".equals(jp.getText())) {
                    throw new RuntimeException("unuspported respone type. No entity-type key found at top of the object");
                }
                jp.nextToken();
                String etype = jp.getText();
                jm = JsonMarshalling.getMarshaller(etype);
                if (jm != null) break block36;
                try {
                    AutomationClientActivator automationClientActivator = AutomationClientActivator.getInstance();
                    Class loadClass = automationClientActivator == null ? Thread.currentThread().getContextClassLoader().loadClass(etype) : automationClientActivator.getContext().getBundle().loadClass(etype);
                    ObjectMapper mapper = new ObjectMapper();
                    jp.nextToken();
                    jp.nextToken();
                    jp.nextToken();
                    Object object = mapper.readValue(jp, loadClass);
                    return object;
                }
                catch (ClassNotFoundException e) {
                    TreeNode treeNode;
                    Throwable throwable2;
                    JsonParser jp2;
                    block34: {
                        block35: {
                            log.warn((Object)("No marshaller for " + etype + " and not a valid Java class name either."));
                            jp2 = factory.createParser(content);
                            throwable2 = null;
                            treeNode = jp2.readValueAsTree();
                            if (jp == null) break block34;
                            if (throwable == null) break block35;
                            try {
                                jp.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block34;
                        }
                        jp.close();
                    }
                    return treeNode;
                    {
                        catch (Throwable throwable4) {
                            throwable2 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (jp2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        jp2.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                } else {
                                    jp2.close();
                                }
                            }
                        }
                    }
                }
            }
            Object t = jm.read(jp);
            return t;
            {
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                catch (Throwable throwable7) {
                    throw throwable7;
                }
            }
        }
    }

    public static String writeRequest(OperationRequest req) throws IOException {
        StringWriter writer = new StringWriter();
        Object input = req.getInput();
        try (JsonGenerator jg = factory.createGenerator((Writer)writer);){
            jg.writeStartObject();
            if (input instanceof OperationInput) {
                OperationInput operationInput = (OperationInput)input;
                String ref = operationInput.getInputRef();
                if (ref != null) {
                    jg.writeStringField("input", ref);
                }
            } else if (input != null) {
                JsonMarshaller<?> marshaller = JsonMarshalling.getMarshaller(input.getClass());
                if (marshaller != null) {
                    jg.writeFieldName("input");
                    marshaller.write(jg, input);
                } else {
                    jg.writeObjectField("input", input);
                }
            }
            jg.writeObjectFieldStart("params");
            JsonMarshalling.writeMap(jg, req.getParameters());
            jg.writeEndObject();
            jg.writeObjectFieldStart("context");
            JsonMarshalling.writeMap(jg, req.getContextParameters());
            jg.writeEndObject();
            jg.writeEndObject();
        }
        return writer.toString();
    }

    public static void writeMap(JsonGenerator jg, Map<String, Object> map) throws IOException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object param = entry.getValue();
            jg.writeFieldName(entry.getKey());
            JsonMarshalling.write(jg, param);
        }
    }

    public static void write(JsonGenerator jg, Object obj) throws IOException {
        if (obj != null) {
            JsonMarshaller<?> marshaller = JsonMarshalling.getMarshaller(obj.getClass());
            if (marshaller != null) {
                try {
                    marshaller.write(jg, obj);
                }
                catch (UnsupportedOperationException e) {
                    jg.writeObject(obj);
                }
            } else if (obj instanceof String) {
                jg.writeString((String)obj);
            } else if (obj instanceof PropertyMap || obj instanceof OperationInput) {
                jg.writeString(obj.toString());
            } else if (obj instanceof Iterable) {
                jg.writeStartArray();
                for (Object object : (Iterable)obj) {
                    JsonMarshalling.write(jg, object);
                }
                jg.writeEndArray();
            } else if (obj.getClass().isArray()) {
                jg.writeStartArray();
                for (Object object : (Object[])obj) {
                    JsonMarshalling.write(jg, object);
                }
                jg.writeEndArray();
            } else {
                jg.writeObject(obj);
            }
        } else {
            jg.writeNull();
        }
    }

    static {
        JsonMarshalling.addMarshaller(new DocumentMarshaller());
        JsonMarshalling.addMarshaller(new DocumentsMarshaller());
        JsonMarshalling.addMarshaller(new ExceptionMarshaller());
        JsonMarshalling.addMarshaller(new LoginMarshaller());
        JsonMarshalling.addMarshaller(new RecordSetMarshaller());
        JsonMarshalling.addMarshaller(new StringMarshaller());
        JsonMarshalling.addMarshaller(new BooleanMarshaller());
        JsonMarshalling.addMarshaller(new NumberMarshaller());
        JsonMarshalling.addMarshaller(new DateMarshaller());
    }

    public static class ThrowableDeserializer
    extends com.fasterxml.jackson.databind.deser.std.ThrowableDeserializer {
        protected Stack<Map<String, JsonNode>> unknownStack = new Stack();

        public ThrowableDeserializer(BeanDeserializer src) {
            super(src);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object deserializeFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            this.unknownStack.push(new HashMap());
            try {
                RemoteThrowable t = (RemoteThrowable)super.deserializeFromObject(jp, ctxt);
                t.getOtherNodes().putAll(this.unknownStack.peek());
                RemoteThrowable remoteThrowable = t;
                return remoteThrowable;
            }
            finally {
                this.unknownStack.pop();
            }
        }
    }

    public static class ThowrableTypeModifier
    extends TypeModifier {
        public JavaType modifyType(JavaType type, Type jdkType, TypeBindings context, TypeFactory typeFactory) {
            Class raw = type.getRawClass();
            if (raw.equals(Throwable.class)) {
                return SimpleType.construct(RemoteThrowable.class);
            }
            return type;
        }
    }
}

