/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    private static final long serialVersionUID = 1L;
    public final int fid;
    public final byte[] gtrid;
    public final byte[] bqual;

    public XidImpl(Xid xid) {
        this.fid = xid.getFormatId();
        this.gtrid = (byte[])xid.getGlobalTransactionId().clone();
        this.bqual = (byte[])xid.getBranchQualifier().clone();
    }

    public XidImpl(String id) {
        this.fid = 0;
        this.gtrid = id.getBytes();
        this.bqual = new byte[]{0};
    }

    @Override
    public int getFormatId() {
        return this.fid;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return (byte[])this.gtrid.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        return (byte[])this.bqual.clone();
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + this.fid;
        hash = 31 * hash + Arrays.hashCode(this.gtrid);
        hash = 31 * hash + Arrays.hashCode(this.bqual);
        return hash;
    }

    public boolean equals(Object other) {
        if (!(other instanceof XidImpl)) {
            return false;
        }
        return this.equals((XidImpl)other);
    }

    private final boolean equals(XidImpl other) {
        if (other == this) {
            return true;
        }
        return this.fid == other.fid && Arrays.equals(this.gtrid, other.gtrid) && Arrays.equals(this.bqual, other.bqual);
    }
}

