/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import java.io.IOException;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMHelper;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.XSetter;
import org.nuxeo.common.xmap.annotation.XContent;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class XAnnotatedContent
extends XAnnotatedMember {
    private static final OutputFormat DEFAULT_FORMAT = new OutputFormat();

    public XAnnotatedContent(XMap xmap, XSetter setter, XContent anno) {
        super(xmap, setter);
        this.path = new Path(anno.value());
        this.type = setter.getType();
        this.valueFactory = xmap.getValueFactory(this.type);
        this.xao = xmap.register(this.type);
    }

    protected Object getValue(Context ctx, Element base) throws IOException {
        Element el = (Element)DOMHelper.getElementNode((Node)base, this.path);
        if (el == null) {
            return null;
        }
        el.normalize();
        Node node = el.getFirstChild();
        if (node == null) {
            return "";
        }
        Range range = ((DocumentRange)((Object)el.getOwnerDocument())).createRange();
        range.setStartBefore(node);
        range.setEndAfter(el.getLastChild());
        DocumentFragment fragment = range.cloneContents();
        boolean asDOM = this.setter.getType() == DocumentFragment.class;
        return asDOM ? fragment : DOMSerializer.toString(fragment, DEFAULT_FORMAT);
    }

    static {
        DEFAULT_FORMAT.setOmitXMLDeclaration(true);
        DEFAULT_FORMAT.setIndenting(true);
        DEFAULT_FORMAT.setMethod("xml");
        DEFAULT_FORMAT.setEncoding("UTF-8");
    }
}

