/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import org.nuxeo.common.utils.StringUtils;

public final class IdUtils {
    private static final String WORD_SPLITTING_REGEXP = "[^a-zA-Z0-9]+";
    private static final Random RANDOM = new Random(new Date().getTime());

    private IdUtils() {
    }

    public static String generateStringId() {
        return String.valueOf(RANDOM.nextLong());
    }

    public static long generateLongId() {
        return RANDOM.nextLong();
    }

    public static String generateId(String s, String wordSeparator, boolean lower, int maxChars) {
        String id;
        s = StringUtils.toAscii(s);
        s = s.trim();
        if (lower) {
            s = s.toLowerCase();
        }
        String[] words = s.split(WORD_SPLITTING_REGEXP);
        ArrayList<String> wordsList = new ArrayList<String>();
        for (String word : words) {
            if (word == null || word.length() <= 0) continue;
            wordsList.add(word);
        }
        if (wordsList.isEmpty()) {
            return IdUtils.generateStringId();
        }
        if (maxChars > 0) {
            id = (String)wordsList.get(0);
            for (int i = 1; i < wordsList.size(); ++i) {
                String newWord = (String)wordsList.get(i);
                if (id.length() + newWord.length() > maxChars) break;
                id = id + wordSeparator + newWord;
            }
            id = id.substring(0, Math.min(id.length(), maxChars));
        } else {
            id = StringUtils.join(wordsList.toArray(), wordSeparator);
        }
        return id;
    }

    public static String generateId(String s) {
        return IdUtils.generateId(s, "-", true, 24);
    }
}

