/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.persistence;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.persistence.Memento;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLMemento
implements Memento {
    private static final Log log = LogFactory.getLog(XMLMemento.class);
    private final Document factory;
    private final Element element;

    public XMLMemento(Document document, Element element) {
        this.factory = document;
        this.element = element;
    }

    public static XMLMemento createReadRoot(Reader reader) throws Exception {
        return XMLMemento.createReadRoot(reader, null);
    }

    public static XMLMemento createReadRoot(Reader reader, String baseDir) throws Exception {
        String errorMessage = null;
        Exception exception = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource source = new InputSource(reader);
            if (baseDir != null) {
                source.setSystemId(baseDir);
            }
            Document document = parser.parse(source);
            NodeList list = document.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!(node instanceof Element)) continue;
                return new XMLMemento(document, (Element)node);
            }
        }
        catch (ParserConfigurationException e) {
            exception = e;
            errorMessage = "Parser Config Error";
        }
        catch (IOException e) {
            exception = e;
            errorMessage = "IO Error";
        }
        catch (SAXException e) {
            exception = e;
            errorMessage = "format error";
        }
        String problemText = null;
        if (exception != null) {
            problemText = exception.getMessage();
        }
        if (problemText == null || problemText.length() == 0) {
            problemText = errorMessage != null ? errorMessage : "No such element";
        }
        throw new Exception(problemText, exception);
    }

    public static XMLMemento createWriteRoot(String type) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(type);
            document.appendChild(element);
            return new XMLMemento(document, element);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e.getMessage());
        }
    }

    public Memento createChild(String type) {
        Element child = this.factory.createElement(type);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    public Memento createChild(String type, String id) {
        Element child = this.factory.createElement(type);
        child.setAttribute("IMemento.internal.id", id == null ? "" : id);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    public Memento copyChild(Memento child) {
        Element childElement = ((XMLMemento)child).element;
        Element newElement = (Element)this.factory.importNode(childElement, true);
        this.element.appendChild(newElement);
        return new XMLMemento(this.factory, newElement);
    }

    public Memento getChild(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        for (int nX = 0; nX < size; ++nX) {
            Element element;
            Node node = nodes.item(nX);
            if (!(node instanceof Element) || !(element = (Element)node).getNodeName().equals(type)) continue;
            return new XMLMemento(this.factory, element);
        }
        return null;
    }

    public Memento[] getChildren(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return new Memento[0];
        }
        ArrayList<Element> list = new ArrayList<Element>(size);
        for (int nX = 0; nX < size; ++nX) {
            Element element;
            Node node = nodes.item(nX);
            if (!(node instanceof Element) || !(element = (Element)node).getNodeName().equals(type)) continue;
            list.add(element);
        }
        size = list.size();
        Memento[] results = new Memento[size];
        for (int x = 0; x < size; ++x) {
            results[x] = new XMLMemento(this.factory, (Element)list.get(x));
        }
        return results;
    }

    public Float getFloat(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Float(strValue);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Memento problem - Invalid float for key: " + key + " value: " + strValue), (Throwable)e);
            return null;
        }
    }

    public String getID() {
        return this.element.getAttribute("IMemento.internal.id");
    }

    public Integer getInteger(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return Integer.valueOf(strValue);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Memento problem - invalid integer for key: " + key + " value: " + strValue), (Throwable)e);
            return null;
        }
    }

    public Boolean getBoolean(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        return Boolean.valueOf(strValue);
    }

    public String getString(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public String getTextData() {
        Text textNode = this.getTextNode();
        if (textNode != null) {
            return textNode.getData();
        }
        return null;
    }

    private Text getTextNode() {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        for (int nX = 0; nX < size; ++nX) {
            Node node = nodes.item(nX);
            if (!(node instanceof Text)) continue;
            return (Text)node;
        }
        return null;
    }

    private void putElement(Element element, boolean copyText) {
        NamedNodeMap nodeMap = element.getAttributes();
        int size = nodeMap.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)nodeMap.item(i);
            this.putString(attr.getName(), attr.getValue());
        }
        NodeList nodes = element.getChildNodes();
        size = nodes.getLength();
        boolean needToCopyText = copyText;
        for (int i = 0; i < size; ++i) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                XMLMemento child = (XMLMemento)this.createChild(node.getNodeName());
                child.putElement((Element)node, true);
                continue;
            }
            if (!(node instanceof Text) || !needToCopyText) continue;
            this.putTextData(((Text)node).getData());
            needToCopyText = false;
        }
    }

    public void putFloat(String key, float f) {
        this.element.setAttribute(key, String.valueOf(f));
    }

    public void putInteger(String key, int n) {
        this.element.setAttribute(key, String.valueOf(n));
    }

    public void putBoolean(String key, boolean value) {
        this.element.setAttribute(key, String.valueOf(value));
    }

    public void putMemento(Memento memento) {
        this.putElement(((XMLMemento)memento).element, false);
    }

    public void putString(String key, String value) {
        if (value == null) {
            return;
        }
        this.element.setAttribute(key, value);
    }

    public void putTextData(String data) {
        Text textNode = this.getTextNode();
        if (textNode == null) {
            textNode = this.factory.createTextNode(data);
            this.element.insertBefore(textNode, this.element.getFirstChild());
        } else {
            textNode.setData(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Writer writer) {
        DOMWriter out = new DOMWriter(writer);
        try {
            out.print(this.element);
        }
        finally {
            out.close();
        }
    }

    private static final class DOMWriter
    extends PrintWriter {
        private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        private int tab = 0;

        DOMWriter(Writer output) {
            super(output);
            this.println(XML_VERSION);
        }

        public void print(Element element) {
            boolean hasChildren = element.hasChildNodes();
            this.startTag(element, hasChildren);
            if (hasChildren) {
                ++this.tab;
                boolean prevWasText = false;
                NodeList children = element.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node instanceof Element) {
                        if (!prevWasText) {
                            this.println();
                            this.printTabulation();
                        }
                        this.print((Element)children.item(i));
                        prevWasText = false;
                        continue;
                    }
                    if (!(node instanceof Text)) continue;
                    this.print(DOMWriter.getEscaped(node.getNodeValue()));
                    prevWasText = true;
                }
                --this.tab;
                if (!prevWasText) {
                    this.println();
                    this.printTabulation();
                }
                this.endTag(element);
            }
        }

        private void printTabulation() {
        }

        private void startTag(Element element, boolean hasChildren) {
            StringBuffer sb = new StringBuffer();
            sb.append('<');
            sb.append(element.getTagName());
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                sb.append(' ');
                sb.append(attribute.getName());
                sb.append("=\"");
                sb.append(DOMWriter.getEscaped(String.valueOf(attribute.getValue())));
                sb.append('\"');
            }
            sb.append(hasChildren ? ">" : "/>");
            this.print(sb.toString());
        }

        private void endTag(Element element) {
            StringBuffer sb = new StringBuffer();
            sb.append("</");
            sb.append(element.getNodeName());
            sb.append('>');
            this.print(sb.toString());
        }

        private static void appendEscapedChar(StringBuffer buffer, char c) {
            String replacement = DOMWriter.getReplacement(c);
            if (replacement != null) {
                buffer.append('&');
                buffer.append(replacement);
                buffer.append(';');
            } else {
                buffer.append(c);
            }
        }

        private static String getEscaped(String s) {
            StringBuffer result = new StringBuffer(s.length() + 10);
            for (int i = 0; i < s.length(); ++i) {
                DOMWriter.appendEscapedChar(result, s.charAt(i));
            }
            return result.toString();
        }

        private static String getReplacement(char c) {
            switch (c) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
                case '\r': {
                    return "#x0D";
                }
                case '\n': {
                    return "#x0A";
                }
                case '\t': {
                    return "#x09";
                }
            }
            return null;
        }
    }
}

