/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.test;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.binary.metadata.test.BinaryMetadataFeature;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={BinaryMetadataFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.platform.picture.api"}), @Deploy(value={"org.nuxeo.ecm.platform.picture.core"}), @Deploy(value={"org.nuxeo.ecm.platform.picture.convert"}), @Deploy(value={"org.nuxeo.ecm.platform.rendition.core"}), @Deploy(value={"org.nuxeo.ecm.automation.core"}), @Deploy(value={"org.nuxeo.ecm.platform.tag"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-test.xml"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-pdf-test.xml"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-provider.xml"})})
@RepositoryConfig(cleanup=Granularity.METHOD)
public class TestBinaryMetadataSyncListener {
    @Inject
    CoreSession session;

    @Test
    public void testListener() throws Exception {
        DocumentModel doc = this.session.createDocumentModel("/", "folder", "Folder");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"Folder"));
        this.session.createDocument(doc);
        doc = this.session.createDocumentModel("/folder", "file", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"file"));
        doc = this.session.createDocument(doc);
        File binary = FileUtils.getResourceFileFromContext((String)"data/hello.pdf");
        Blob fb = Blobs.createBlob((File)binary, (String)"application/pdf");
        DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
        this.session.saveDocument(doc);
        DocumentModel pdfDoc = this.session.getDocument(doc.getRef());
        Assert.assertEquals((Object)"en-US", (Object)pdfDoc.getPropertyValue("dc:title"));
        Assert.assertEquals((Object)"OpenOffice.org 3.2", (Object)pdfDoc.getPropertyValue("dc:source"));
        Assert.assertEquals((Object)"Writer", (Object)pdfDoc.getPropertyValue("dc:coverage"));
        Assert.assertEquals((Object)"Mirko Nasato", (Object)pdfDoc.getPropertyValue("dc:creator"));
        Assert.assertEquals((Object)"OpenOffice.org 3.2", (Object)pdfDoc.getPropertyValue("dc:description"));
        pdfDoc.setPropertyValue("dc:title", (Serializable)((Object)"notFromBlob"));
        pdfDoc.setPropertyValue("file:content", null);
        this.session.saveDocument(pdfDoc);
        pdfDoc = this.session.getDocument(pdfDoc.getRef());
        Assert.assertEquals((Object)"notFromBlob", (Object)pdfDoc.getPropertyValue("dc:title"));
        pdfDoc.setPropertyValue("dc:title", (Serializable)((Object)"notFromBlob"));
        DocumentHelper.addBlob((Property)pdfDoc.getProperty("file:content"), (Blob)fb);
        this.session.saveDocument(pdfDoc);
        pdfDoc = this.session.getDocument(pdfDoc.getRef());
        Assert.assertEquals((Object)"en-US", (Object)pdfDoc.getPropertyValue("dc:title"));
    }

    @Test
    public void testCollaborativeSaveOnlyIncrementsVersionOnce() throws Exception {
        DocumentModel doc = this.session.createDocumentModel("/", "file", "File");
        doc.setPropertyValue("dc:lastContributor", (Serializable)((Object)"laurel"));
        doc = this.session.createDocument(doc);
        File file = FileUtils.getResourceFileFromContext((String)"data/hello.pdf");
        Blob blob = Blobs.createBlob((File)file, (String)"application/pdf");
        DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)blob);
        doc.setPropertyValue("dc:lastContributor", (Serializable)((Object)"hardy"));
        doc = this.session.saveDocument(doc);
        Assert.assertEquals((Object)"0.1+", (Object)doc.getVersionLabel());
    }

    @Test
    public void testEXIFandIPTC() throws IOException {
        DocumentModel doc = this.session.createDocumentModel("/", "folder", "Folder");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"Folder"));
        this.session.createDocument(doc);
        doc = this.session.createDocumentModel("/folder", "picture", "Picture");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"picture"));
        doc = this.session.createDocument(doc);
        File binary = FileUtils.getResourceFileFromContext((String)"data/china.jpg");
        Blob fb = Blobs.createBlob((File)binary, (String)"image/jpeg");
        DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
        this.session.saveDocument(doc);
        DocumentModel picture = this.session.getDocument(doc.getRef());
        Assert.assertEquals((Object)"Horizontal (normal)", (Object)picture.getPropertyValue("imd:orientation"));
        Assert.assertEquals((Object)2.4, (Object)picture.getPropertyValue("imd:fnumber"));
        doc = this.session.createDocumentModel("/folder", "picture1", "Picture");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"picture"));
        doc = this.session.createDocument(doc);
        binary = FileUtils.getResourceFileFromContext((String)"data/iptc_sample.jpg");
        fb = Blobs.createBlob((File)binary, (String)"image/jpeg");
        DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
        this.session.saveDocument(doc);
        picture = this.session.getDocument(doc.getRef());
        Assert.assertEquals((Object)"DDP", (Object)picture.getPropertyValue("dc:source"));
        Assert.assertEquals((Object)"ImageForum", (Object)picture.getPropertyValue("dc:rights"));
        Assert.assertEquals((Object)"Music", (Object)picture.getPropertyValue("dc:description").toString().substring(0, 5));
    }

    @Test
    public void testUpdateOnBlobsFromProvidersWhichPreventUserUpdate() {
        DocumentModel doc = this.session.createDocumentModel("/", "folder", "Folder");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"Folder"));
        this.session.createDocument(doc);
        doc = this.session.createDocumentModel("/folder", "picture", "Picture");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"a picture file"));
        doc = this.session.createDocument(doc);
        BlobInfo blobInfo = new BlobInfo();
        blobInfo.key = "testProvider:user@testProvider.com:0134cc5";
        blobInfo.digest = "5cc31b4305e2beb7191f717448";
        blobInfo.filename = "iptc_sample.jpg";
        blobInfo.mimeType = "image/jpeg";
        SimpleManagedBlob blob = new SimpleManagedBlob(blobInfo);
        DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)blob);
        this.session.save();
        doc.setPropertyValue("imd:user_comment", (Serializable)((Object)"a comment"));
        this.session.saveDocument(doc);
        Blob anotherBlob = (Blob)doc.getProperty("file:content").getValue();
        Assert.assertEquals((Object)blob, (Object)anotherBlob);
    }
}

