/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.test;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.binary.metadata.api.BinaryMetadataService;
import org.nuxeo.binary.metadata.test.BinaryMetadataFeature;
import org.nuxeo.binary.metadata.test.BinaryMetadataServerInit;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={BinaryMetadataFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.automation.core"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-test.xml"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-disable-listener.xml"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-pdf-test.xml"})})
@RepositoryConfig(cleanup=Granularity.METHOD, init=BinaryMetadataServerInit.class)
public class TestBinaryMetadataOperation {
    @Inject
    AutomationService automationService;
    @Inject
    OperationContext operationContext;
    @Inject
    BinaryMetadataService binaryMetadataService;
    @Inject
    CoreSession session;
    private static final Map<String, Object> triggerParameters = new HashMap<String, Object>();
    private static final Properties jpgMetadata;
    private static final Map<String, Object> jpgParameters;

    @Test
    public void itShouldExtractBinaryMetadata() throws OperationException {
        DocumentModel musicFile = BinaryMetadataServerInit.getFile(0, this.session);
        BlobHolder musicBlobHolder = (BlobHolder)musicFile.getAdapter(BlobHolder.class);
        this.operationContext.setInput((Object)musicBlobHolder.getBlob());
        Map blobProperties = (Map)this.automationService.run(this.operationContext, "Blob.ReadMetadata");
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((Object)"Twist", (Object)blobProperties.get("Title").toString());
        Assert.assertEquals((Object)"Divine Recordings", (Object)blobProperties.get("Publisher").toString());
    }

    @Test
    public void itShouldApplyMetadataMapping() throws OperationException {
        DocumentModel pdfDoc = BinaryMetadataServerInit.getFile(1, this.session);
        this.operationContext.setInput((Object)pdfDoc);
        this.operationContext.setCoreSession(this.session);
        this.automationService.run(this.operationContext, "Document.SetMetadataFromBlob", triggerParameters);
        pdfDoc = BinaryMetadataServerInit.getFile(1, this.session);
        Assert.assertEquals((Object)"en-US", (Object)pdfDoc.getPropertyValue("dc:title"));
        Assert.assertEquals((Object)"OpenOffice.org 3.2", (Object)pdfDoc.getPropertyValue("dc:source"));
    }

    @Test
    public void itShouldWriteMetadataOnBinary() throws OperationException {
        DocumentModel jpgFile = BinaryMetadataServerInit.getFile(4, this.session);
        BlobHolder jpgBlobHolder = (BlobHolder)jpgFile.getAdapter(BlobHolder.class);
        Blob blob = jpgBlobHolder.getBlob();
        Map blobProperties = this.binaryMetadataService.readMetadata(blob, false);
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((Object)"Google", blobProperties.get("EXIF:Make"));
        Assert.assertEquals((Object)"Nexus", (Object)blobProperties.get("EXIF:Model").toString());
        this.operationContext.setInput((Object)blob);
        this.operationContext.setCoreSession(this.session);
        Blob newBlob = (Blob)this.automationService.run(this.operationContext, "Blob.SetMetadataFromContext", jpgParameters);
        blobProperties = this.binaryMetadataService.readMetadata(newBlob, false);
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((Object)"Nuxeo", blobProperties.get("EXIF:Make"));
        Assert.assertEquals((Object)"Platform", (Object)blobProperties.get("EXIF:Model").toString());
        jpgMetadata.put((Object)"EXIF:Model", (Object)"Google");
        jpgMetadata.put((Object)"EXIF:Make", (Object)"Nexus");
        jpgParameters.put("metadata", jpgMetadata);
        this.operationContext.setInput((Object)jpgFile);
        this.operationContext.setCoreSession(this.session);
        this.automationService.run(this.operationContext, "Blob.SetMetadataFromDocument", jpgParameters);
        blobProperties = this.binaryMetadataService.readMetadata(jpgBlobHolder.getBlob(), false);
        Assert.assertNotNull((Object)blobProperties);
        Assert.assertEquals((Object)"Nexus", blobProperties.get("EXIF:Make"));
        Assert.assertEquals((Object)"Google", (Object)blobProperties.get("EXIF:Model").toString());
    }

    @Test
    public void itShouldPutBinaryMetadataInAutomationCtx() throws OperationException {
        DocumentModel musicFile = BinaryMetadataServerInit.getFile(0, this.session);
        BlobHolder musicBlobHolder = (BlobHolder)musicFile.getAdapter(BlobHolder.class);
        this.operationContext.setInput((Object)musicBlobHolder.getBlob());
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("ignorePrefix", false);
        this.automationService.run(this.operationContext, "Context.SetMetadataFromBlob", params);
        Assert.assertNotNull((Object)this.operationContext.get((Object)"binaryMetadata"));
        Assert.assertEquals((Object)"Metal", ((Map)this.operationContext.get((Object)"binaryMetadata")).get("ID3:Genre"));
        this.operationContext.setInput((Object)musicBlobHolder.getBlob());
        HashMap<String, StringList> parameters = new HashMap<String, StringList>();
        StringList metadata = new StringList();
        metadata.add((Object)"ID3:Title");
        metadata.add((Object)"ID3:Year");
        parameters.put("metadata", metadata);
        this.automationService.run(this.operationContext, "Context.SetMetadataFromBlob", parameters);
        Assert.assertNotNull((Object)this.operationContext.get((Object)"binaryMetadata"));
        Assert.assertNull(((Map)this.operationContext.get((Object)"binaryMetadata")).get("ID3:Genre"));
        Assert.assertEquals((long)2L, (long)((Map)this.operationContext.get((Object)"binaryMetadata")).size());
    }

    static {
        triggerParameters.put("metadataMappingId", "PDF");
        jpgParameters = new HashMap<String, Object>();
        jpgMetadata = new Properties();
        jpgMetadata.put((Object)"EXIF:Model", (Object)"Platform");
        jpgMetadata.put((Object)"EXIF:Make", (Object)"Nuxeo");
        jpgParameters.put("metadata", jpgMetadata);
    }
}

