/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.test;

import java.io.File;
import java.io.Serializable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.binary.metadata.test.BinaryMetadataFeature;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.TransactionalFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={BinaryMetadataFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-async-test.xml"}), @Deploy(value={"org.nuxeo.binary.metadata:binary-metadata-contrib-pdf-test.xml"})})
@RepositoryConfig(cleanup=Granularity.METHOD)
public class TestBinaryMetadataAsyncListener {
    @Inject
    CoreSession session;
    @Inject
    EventService eventService;
    @Inject
    TransactionalFeature txFeature;

    @Test
    public void testListener() throws Exception {
        DocumentModel doc = this.session.createDocumentModel("/", "folder", "Folder");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"Folder"));
        this.session.createDocument(doc);
        doc = this.session.createDocumentModel("/folder", "file", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"file"));
        doc = this.session.createDocument(doc);
        File binary = FileUtils.getResourceFileFromContext((String)"data/hello.pdf");
        Blob fb = Blobs.createBlob((File)binary, (String)"application/pdf");
        DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
        this.session.saveDocument(doc);
        this.txFeature.nextTransaction();
        DocumentModel pdfDoc = this.session.getDocument(doc.getRef());
        Assert.assertEquals((Object)"en-US", (Object)pdfDoc.getPropertyValue("dc:title"));
        Assert.assertEquals((Object)"OpenOffice.org 3.2", (Object)pdfDoc.getPropertyValue("dc:source"));
        Assert.assertEquals((Object)"Writer", (Object)pdfDoc.getPropertyValue("dc:coverage"));
        Assert.assertEquals((Object)"Mirko Nasato", (Object)pdfDoc.getPropertyValue("dc:creator"));
        Assert.assertEquals((Object)"OpenOffice.org 3.2", (Object)pdfDoc.getPropertyValue("dc:description"));
    }
}

