/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.activity.ActivityStream;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ActivityStreamRegistry
extends ContributionFragmentRegistry<ActivityStream> {
    protected Map<String, ActivityStream> activityStreams = new HashMap<String, ActivityStream>();

    public ActivityStream get(String name) {
        return this.activityStreams.get(name);
    }

    public String getContributionId(ActivityStream contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, ActivityStream contrib, ActivityStream newOrigContrib) {
        this.activityStreams.put(id, contrib);
    }

    public void contributionRemoved(String id, ActivityStream origContrib) {
        this.activityStreams.remove(id);
    }

    public ActivityStream clone(ActivityStream orig) {
        return orig.clone();
    }

    public void merge(ActivityStream src, ActivityStream dst) {
        List<String> newRelationshipKinds;
        List<String> newVerbs = src.getVerbs();
        if (newVerbs != null) {
            List<String> oldVerbs;
            boolean keepOld;
            ArrayList<String> merged = new ArrayList<String>();
            merged.addAll(newVerbs);
            boolean bl = keepOld = src.isAppendVerbs() || newVerbs.isEmpty() && !src.isAppendVerbs();
            if (keepOld && (oldVerbs = dst.getVerbs()) != null) {
                merged.addAll(0, oldVerbs);
            }
            dst.setVerbs(merged);
        }
        if ((newRelationshipKinds = src.getRelationshipKinds()) != null) {
            List<String> oldRelationshipKinds;
            boolean keepOld;
            ArrayList<String> merged = new ArrayList<String>();
            merged.addAll(newRelationshipKinds);
            boolean bl = keepOld = src.isAppendRelationshipKinds() || newRelationshipKinds.isEmpty() && !src.isAppendRelationshipKinds();
            if (keepOld && (oldRelationshipKinds = dst.getRelationshipKinds()) != null) {
                merged.addAll(0, oldRelationshipKinds);
            }
            dst.setRelationshipKinds(merged);
        }
    }
}

