/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="activityStream")
public class ActivityStream {
    @XNode(value="@name")
    String name;
    @XNode(value="verbs@append")
    boolean appendVerbs;
    @XNodeList(value="verbs/verb", type=ArrayList.class, componentType=String.class)
    List<String> verbs;
    @XNode(value="relationshipKinds@append")
    boolean appendRelationshipKinds;
    @XNodeList(value="relationshipKinds/relationshipKind", type=ArrayList.class, componentType=String.class)
    List<String> relationshipKinds;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isAppendVerbs() {
        return this.appendVerbs;
    }

    public void setAppendVerbs(boolean appendVerbs) {
        this.appendVerbs = appendVerbs;
    }

    public List<String> getVerbs() {
        if (this.verbs == null) {
            return Collections.emptyList();
        }
        return this.verbs;
    }

    public void setVerbs(List<String> verbs) {
        this.verbs = verbs;
    }

    public boolean isAppendRelationshipKinds() {
        return this.appendRelationshipKinds;
    }

    public void setAppendRelationshipKinds(boolean appendRelationshipKinds) {
        this.appendRelationshipKinds = appendRelationshipKinds;
    }

    public List<String> getRelationshipKinds() {
        if (this.relationshipKinds == null) {
            return Collections.emptyList();
        }
        return this.relationshipKinds;
    }

    public void setRelationshipKinds(List<String> relationshipKinds) {
        this.relationshipKinds = relationshipKinds;
    }

    public ActivityStream clone() {
        ActivityStream clone = new ActivityStream();
        clone.setName(this.getName());
        clone.setAppendVerbs(this.isAppendVerbs());
        List<String> verbs = this.getVerbs();
        if (verbs != null) {
            ArrayList<String> newVerbs = new ArrayList<String>();
            for (String verb : verbs) {
                newVerbs.add(verb);
            }
            clone.setVerbs(newVerbs);
        }
        clone.setAppendRelationshipKinds(this.isAppendRelationshipKinds());
        List<String> relationshipKinds = this.getRelationshipKinds();
        if (relationshipKinds != null) {
            ArrayList<String> newRelationshipKinds = new ArrayList<String>();
            for (String kind : relationshipKinds) {
                newRelationshipKinds.add(kind);
            }
            clone.setRelationshipKinds(newRelationshipKinds);
        }
        return clone;
    }
}

