/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.io.Serializable;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.GifRenderer;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.ResourceRenderer;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.Zipper;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public abstract class TreeImageBase
extends Java2Dresource {
    public TreeImageBase() {
        this.setRenderer((ResourceRenderer)new GifRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        int intValue;
        TreeImageData dt = new TreeImageData();
        Skin skin = SkinFactory.getInstance().getSkin(context);
        Skin defaultSkin = SkinFactory.getInstance().getDefaultSkin(context);
        String skinParameter = "generalTextColor";
        String tmp = (String)skin.getParameter(context, skinParameter);
        if (null == tmp || "".equals(tmp)) {
            tmp = (String)defaultSkin.getParameter(context, skinParameter);
        }
        if (tmp != null && !"".equals(tmp)) {
            intValue = HtmlColor.decode((String)tmp).getRGB();
            dt.setGeneralColor(new Integer(intValue));
        } else {
            dt.setGeneralColor(null);
        }
        skinParameter = "controlBackgroundColor";
        tmp = (String)skin.getParameter(context, skinParameter);
        if (null == tmp || "".equals(tmp)) {
            tmp = (String)defaultSkin.getParameter(context, skinParameter);
        }
        if (tmp != null && !"".equals(tmp)) {
            intValue = HtmlColor.decode((String)tmp).getRGB();
            dt.setControlColor(new Integer(intValue));
        } else {
            dt.setControlColor(null);
        }
        skinParameter = "trimColor";
        tmp = (String)skin.getParameter(context, skinParameter);
        if (null == tmp || "".equals(tmp)) {
            tmp = (String)defaultSkin.getParameter(context, skinParameter);
        }
        if (tmp != null && !"".equals(tmp)) {
            intValue = HtmlColor.decode((String)tmp).getRGB();
            dt.setTrimColor(new Integer(intValue));
        } else {
            dt.setTrimColor(null);
        }
        return dt.toByteArray();
    }

    public boolean isCacheable() {
        return true;
    }

    public TreeImageData getTreeImageData(ResourceContext resourceContext) {
        return new TreeImageData((byte[])resourceContext.getResourceData());
    }

    protected static class TreeImageData
    implements Serializable {
        private static final long serialVersionUID = 1732700513743861251L;
        private Integer controlColor;
        private Integer trimColor;
        private Integer generalColor;

        public TreeImageData() {
        }

        public TreeImageData(byte[] data) {
            this.controlColor = new Integer(Zipper.unzip((byte[])data, (int)0));
            this.trimColor = new Integer(Zipper.unzip((byte[])data, (int)3));
            this.generalColor = new Integer(Zipper.unzip((byte[])data, (int)6));
        }

        public Integer getControlColor() {
            return this.controlColor;
        }

        public void setControlColor(Integer controlColor) {
            this.controlColor = controlColor;
        }

        public Integer getTrimColor() {
            return this.trimColor;
        }

        public void setTrimColor(Integer trimColor) {
            this.trimColor = trimColor;
        }

        public Integer getGeneralColor() {
            return this.generalColor;
        }

        public void setGeneralColor(Integer generalColor) {
            this.generalColor = generalColor;
        }

        public byte[] toByteArray() {
            byte[] ret = new byte[9];
            Zipper.zip((byte[])ret, (int)this.controlColor, (int)0);
            Zipper.zip((byte[])ret, (int)this.trimColor, (int)3);
            Zipper.zip((byte[])ret, (int)this.generalColor, (int)6);
            return ret;
        }
    }
}

