/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model.selection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.richfaces.model.selection.SelectionRange;

public class ClientSelection
implements Serializable {
    private static final long serialVersionUID = 5855157282287053681L;
    public static final String FLAG_RESET = "x";
    public static final String FLAG_ALL = "a";
    private String selectionFlag;
    private List ranges = new ArrayList();
    private boolean reset = false;
    private boolean selectAll = false;

    public void addRange(SelectionRange range) {
        this.ranges.add(range);
    }

    public boolean isSelected(int i) {
        boolean result;
        Iterator iterator = this.ranges.iterator();
        for (result = false; iterator.hasNext() && !result; result |= ((SelectionRange)iterator.next()).within(i)) {
        }
        return result;
    }

    public List getRanges() {
        return this.ranges;
    }

    public void addIndex(int j) {
        if (this.isSelected(j)) {
            return;
        }
        SelectionRange firstRange = null;
        int s = this.ranges.size();
        int insertPosition = 0;
        for (int i = 0; i < s && insertPosition >= 0; ++i) {
            firstRange = (SelectionRange)this.ranges.get(i);
            if (firstRange.getStartIndex() == j + 1) {
                firstRange.setStartIndex(j);
                insertPosition = -1;
                continue;
            }
            if (firstRange.getEndIndex() == j - 1) {
                SelectionRange range2;
                firstRange.setEndIndex(j);
                if (i + 1 < s && ((range2 = (SelectionRange)this.ranges.get(i + 1)).getStartIndex() == j || range2.getStartIndex() == j + 1)) {
                    this.ranges.remove(i + 1);
                    firstRange.setEndIndex(range2.getEndIndex());
                }
                insertPosition = -1;
                continue;
            }
            if (firstRange.getStartIndex() <= j) continue;
            insertPosition = i;
        }
        if (insertPosition >= 0) {
            firstRange = new SelectionRange(j, j);
            this.ranges.add(insertPosition, firstRange);
            return;
        }
    }

    public boolean isReset() {
        return this.reset;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public String getSelectionFlag() {
        return this.selectionFlag;
    }

    public void setSelectionFlag(String selectionFlag) {
        this.selectionFlag = selectionFlag;
        this.reset = false;
        this.selectAll = false;
        if (FLAG_ALL.equals(selectionFlag)) {
            this.selectAll = true;
        } else if (FLAG_RESET.equals(selectionFlag)) {
            this.reset = true;
        }
    }
}

