/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.elements.std;

import java.util.HashMap;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.el.ELParser;
import org.ajax4jsf.templatecompiler.elements.TemplateElementBase;
import org.apache.velocity.VelocityContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ScriptObjectTemplateElement
extends TemplateElementBase {
    private static final String TEMPLATE = "META-INF/templates/templatecompiler/scriptObject.vm";
    private String variableName;
    private String base;
    private static final Class<?> VARIABLE_TYPE = HashMap.class;
    private static ThreadLocal<String> variableNamesStorage = new ThreadLocal();

    public ScriptObjectTemplateElement(Node element, CompilationContext componentBean) {
        super(element, componentBean);
        NamedNodeMap nnm = element.getAttributes();
        Node varNode = nnm.getNamedItem("var");
        if (varNode == null) {
            throw new RuntimeException("'var' attribute required for c:scriptObject tag!");
        }
        this.variableName = varNode.getNodeValue();
        Node baseNode = nnm.getNamedItem("base");
        if (baseNode != null) {
            this.base = ELParser.compileEL(baseNode.getNodeValue(), componentBean);
        }
        try {
            this.getComponentBean().addVariable(this.variableName, VARIABLE_TYPE.getName());
        }
        catch (CompilationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getBeginElement() throws CompilationException {
        if (variableNamesStorage.get() != null) {
            throw new CompilationException("Nested c:scriptObject tags aren't allowed!");
        }
        variableNamesStorage.set(this.variableName);
        VelocityContext context = new VelocityContext();
        context.put("variable", (Object)this.variableName);
        context.put("type", (Object)VARIABLE_TYPE.getName().replace('$', '.'));
        context.put("base", (Object)this.base);
        return this.getComponentBean().processTemplate(this.getTemplateName(), context);
    }

    protected String getTemplateName() {
        return TEMPLATE;
    }

    public String getEndElement() {
        variableNamesStorage.set(null);
        return null;
    }

    static String getVariableName() {
        return variableNamesStorage.get();
    }
}

