/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.ajax4jsf.builder.config.ParsingException;
import org.ajax4jsf.builder.xml.XMLBody;
import org.ajax4jsf.builder.xml.XMLBodySerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBodyMerge
implements NodeList {
    private String xpath;
    private List<Node> nodes = new ArrayList<Node>();
    private Document document = null;
    private XPathExpression keyXpath = null;
    private StringBuffer content = new StringBuffer();
    private Set<String> keys = new HashSet<String>();

    public XMLBodyMerge(String xpath) {
        this.xpath = xpath;
    }

    public XMLBodyMerge(String xpath, String keyXpath) {
        this(xpath);
        if (keyXpath != null) {
            try {
                XPath newXPath = XPathFactory.newInstance().newXPath();
                this.keyXpath = newXPath.compile(keyXpath);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
        }
    }

    public void add(Node node) {
        String key;
        if (this.keyXpath != null && ((key = this.getKey(node)) == null || this.keys.contains(key))) {
            return;
        }
        if (this.document == null) {
            this.document = node.getOwnerDocument();
        } else {
            node = this.document.importNode(node, true);
        }
        this.nodes.add(node);
    }

    public void add(XMLBody xmlBody) throws ParsingException {
        if (this.xpath != null) {
            NodeList nodeList = xmlBody.getByXpath(this.xpath);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.add(nodeList.item(i));
                }
            }
        } else {
            this.content.append(xmlBody.getContent());
        }
    }

    @Override
    public int getLength() {
        return this.nodes.size();
    }

    @Override
    public Node item(int index) {
        if (index < this.nodes.size()) {
            return this.nodes.get(index);
        }
        return null;
    }

    public void sort(Comparator<Node> comparator) {
        Collections.sort(this.nodes, comparator);
    }

    public String getContent() throws Exception {
        StringBuilder buf = new StringBuilder();
        if (this.content != null) {
            buf.append(this.content);
        }
        if (this.document != null) {
            buf.append(new XMLBodySerializer().serialize(this, this.document));
        }
        return buf.toString();
    }

    private String getKey(Node node) {
        try {
            NodeList list = (NodeList)this.keyXpath.evaluate(node, XPathConstants.NODESET);
            return new XMLBodySerializer().serialize(list, node.getOwnerDocument());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

