/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.render;

import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponentBase;
import org.ajax4jsf.builder.model.Argument;
import org.ajax4jsf.builder.model.JavaClass;
import org.ajax4jsf.builder.model.JavaField;
import org.ajax4jsf.builder.model.JavaImport;
import org.ajax4jsf.builder.model.JavaMethod;
import org.ajax4jsf.builder.model.JavaModifier;
import org.ajax4jsf.builder.model.JavaPackage;
import org.ajax4jsf.builder.model.MethodBody;
import org.ajax4jsf.builder.render.JavaFieldRenderer;
import org.ajax4jsf.builder.render.JavaLanguageElementRenderer;
import org.ajax4jsf.builder.render.JavaMethodRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassRenderer
extends JavaLanguageElementRenderer<JavaClass> {
    private JavaMethodRenderer methodRenderer = new JavaMethodRenderer();
    private JavaFieldRenderer fieldRenderer = new JavaFieldRenderer();

    @Override
    public void render(JavaClass javaClass, PrintWriter out) {
        out.println("package " + javaClass.getPackage().getName() + ";");
        out.println();
        Set<JavaImport> imports = javaClass.getImports();
        for (JavaImport impord : imports) {
            out.println("import " + impord.getName() + ";");
        }
        out.println();
        this.renderAnnotations(javaClass, out);
        this.renderModifiers(javaClass, out);
        out.print("class " + javaClass.getName());
        Class<?> superClass = javaClass.getSuperClass();
        if (!Object.class.getName().equals(superClass.getName())) {
            out.print(" extends " + superClass.getSimpleName());
        }
        out.println("{");
        out.println();
        List<JavaField> fields = javaClass.getFields();
        for (JavaField javaField : fields) {
            this.fieldRenderer.render(javaField, out);
            out.println();
        }
        out.println();
        List<JavaMethod> methods = javaClass.getMethods();
        for (JavaMethod javaMethod : methods) {
            this.methodRenderer.render(javaMethod, out);
            out.println();
        }
        out.println("}");
        out.flush();
        out.close();
    }

    public static void main(String[] args) {
        JavaClass javaClass = new JavaClass("MyClass", new JavaPackage("mypackage"));
        JavaField javaField = new JavaField(Integer.TYPE, "count");
        javaField.setValue(0);
        javaField.getModifiers().add(JavaModifier.PRIVATE);
        javaClass.addField(javaField);
        JavaField field = new JavaField(UIComponentBase.class, "component", "null");
        field.addModifier(JavaModifier.PUBLIC);
        field.addAnnotation(Deprecated.class);
        javaClass.addField(field);
        javaClass.addAnnotation(Deprecated.class);
        JavaMethod accessor = new JavaMethod("getCount", Integer.TYPE, new Argument[0]);
        accessor.setMethodBody(new MethodBody(accessor){

            public String toCode() {
                return "return count;";
            }
        });
        accessor.getModifiers().add(JavaModifier.PUBLIC);
        accessor.getModifiers().add(JavaModifier.FINAL);
        javaClass.addMethod(accessor);
        JavaMethod mutator = new JavaMethod("setCount", new Argument("i", Integer.TYPE));
        mutator.setMethodBody(new MethodBody(mutator){

            public String toCode() {
                return "count = i;";
            }
        });
        mutator.addAnnotation(Tezt.class);
        mutator.addModifier(JavaModifier.PUBLIC);
        mutator.addModifier(JavaModifier.FINAL);
        javaClass.addMethod(mutator);
        PrintWriter printWriter = new PrintWriter(System.out);
        new JavaClassRenderer().render(javaClass, printWriter);
        printWriter.flush();
    }

    static @interface Tezt {
    }
}

