/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.ajax4jsf.builder.model.Argument;
import org.ajax4jsf.builder.model.ClassImport;
import org.ajax4jsf.builder.model.JavaAnnotation;
import org.ajax4jsf.builder.model.JavaField;
import org.ajax4jsf.builder.model.JavaImport;
import org.ajax4jsf.builder.model.JavaLanguageElement;
import org.ajax4jsf.builder.model.JavaMethod;
import org.ajax4jsf.builder.model.JavaPackage;
import org.ajax4jsf.builder.model.MethodBody;
import org.ajax4jsf.builder.model.RuntimeImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClass
extends JavaLanguageElement {
    private List<JavaField> fields = new ArrayList<JavaField>();
    private List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private Set<JavaImport> imports = new TreeSet<JavaImport>(new Comparator<JavaImport>(){

        @Override
        public int compare(JavaImport o1, JavaImport o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });
    private JavaPackage pakg;
    private Class<?> superClass = Object.class;

    public JavaClass(String shortName, JavaPackage pakg, Class<?> superClass) {
        this(shortName, pakg);
        this.setSuperClass(superClass);
    }

    public JavaClass(String shortName, JavaPackage pakg) {
        super(shortName);
        this.pakg = pakg;
    }

    public void addImport(String name) {
        this.imports.add(new RuntimeImport(name));
    }

    public void addImport(Class<?> claz) {
        if (this.shouldAddToImports(claz)) {
            this.imports.add(new ClassImport(claz));
        }
    }

    @Override
    public void addAnnotation(JavaAnnotation annotation) {
        super.addAnnotation(annotation);
        this.addImport(annotation.getType());
    }

    public void addField(JavaField field) {
        this.fields.add(field);
        this.addImport(field.getType());
        List<JavaAnnotation> annotations2 = field.getAnnotations();
        if (annotations2 != null) {
            for (JavaAnnotation javaAnnotation : annotations2) {
                this.addImport(javaAnnotation.getType());
            }
        }
    }

    public void addMethod(JavaMethod method) {
        MethodBody methodBody;
        List<JavaAnnotation> annotations2;
        this.methods.add(method);
        this.addImport(method.getReturnType());
        List<Class<Throwable>> exceptions = method.getExceptions();
        for (Class<Throwable> exception : exceptions) {
            this.addImport(exception);
        }
        List<Argument> arguments = method.getArguments();
        if (arguments != null) {
            for (Argument argument : arguments) {
                this.addImport(argument.getType());
            }
        }
        if ((annotations2 = method.getAnnotations()) != null) {
            for (JavaAnnotation javaAnnotation : annotations2) {
                this.addImport(javaAnnotation.getType());
            }
        }
        if ((methodBody = method.getMethodBody()) != null) {
            Set<Class<?>> usedClasses = methodBody.getUsedClasses();
            for (Class<?> class1 : usedClasses) {
                this.addImport(class1);
            }
        }
    }

    public JavaPackage getPakg() {
        return this.pakg;
    }

    public Class<?> getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(Class<?> superClass) {
        this.superClass = superClass;
        this.addImport(superClass);
    }

    public void setPackage(JavaPackage s) {
        this.pakg = s;
    }

    public JavaPackage getPackage() {
        return this.pakg;
    }

    public List<JavaField> getFields() {
        return this.fields;
    }

    public List<JavaMethod> getMethods() {
        return this.methods;
    }

    public Set<JavaImport> getImports() {
        return this.imports;
    }

    private boolean shouldAddToImports(Class<?> clas) {
        boolean result = false;
        if (clas != null) {
            String importPackageName;
            Package p = clas.getPackage();
            if (!clas.isPrimitive() && p != null && (importPackageName = p.getName()) != null && importPackageName.length() != 0) {
                result = !importPackageName.equals("java.lang") && !importPackageName.equals(this.getPackage().getName());
            }
        }
        return result;
    }
}

