/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.InnerGenerator;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.ajax4jsf.builder.generator.ResourceType;
import org.ajax4jsf.builder.generator.ResourcesConfigGeneratorBean;
import org.ajax4jsf.builder.generator.ResourcesConfigGeneratorBeanEntry;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesDependenciesGenerator
extends InnerGenerator {
    private Map<String, ResourcesConfigGeneratorBean> componentDependencies;
    private String uri;
    private File dependencyFile;

    public ResourcesDependenciesGenerator(JSFGeneratorConfiguration config, Logger log) {
        super(config, log);
    }

    @Override
    public void createFiles(BuilderConfig config) throws GeneratorException {
        try {
            VelocityContext context = new VelocityContext();
            Template template = this.getTemplate();
            HashMap componentsMap = new HashMap();
            for (Map.Entry<String, ResourcesConfigGeneratorBean> entry : this.componentDependencies.entrySet()) {
                HashMap resourcesMap = new HashMap();
                componentsMap.put(entry.getKey(), resourcesMap);
                LinkedHashSet<String> scripts = new LinkedHashSet<String>();
                LinkedHashSet<String> styles = new LinkedHashSet<String>();
                ResourcesConfigGeneratorBean resourcesConfigBean = entry.getValue();
                List<ResourcesConfigGeneratorBeanEntry> dependencies = resourcesConfigBean.getDependencies();
                for (ResourcesConfigGeneratorBeanEntry beanEntry : dependencies) {
                    ResourceType type;
                    if (beanEntry.isDerived() || (type = beanEntry.getType()) == null) continue;
                    switch (type) {
                        case SCRIPT: {
                            scripts.add(beanEntry.getPath());
                            break;
                        }
                        case STYLE: {
                            styles.add(beanEntry.getPath());
                        }
                    }
                }
                resourcesMap.put("scripts", scripts);
                resourcesMap.put("styles", styles);
            }
            context.put("uri", (Object)this.uri);
            context.put("components", componentsMap);
            File configFile = this.getDependencyFile();
            File javaDir = configFile.getParentFile();
            if (!javaDir.exists()) {
                javaDir.mkdirs();
            }
            if (configFile.exists()) {
                configFile.delete();
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(configFile));
            template.merge((Context)context, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (Exception e) {
            throw new GeneratorException(e.getMessage(), e);
        }
    }

    @Override
    protected String getDefaultTemplateName() {
        return "resources-dependencies.vm";
    }

    public Map<String, ResourcesConfigGeneratorBean> getComponentDependencies() {
        return this.componentDependencies;
    }

    public void setComponentDependencies(Map<String, ResourcesConfigGeneratorBean> componentDependencies) {
        this.componentDependencies = componentDependencies;
    }

    public void setDependencyFile(File dependencyFile) {
        this.dependencyFile = dependencyFile;
    }

    public File getDependencyFile() {
        return this.dependencyFile;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

