/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashSet;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.ComponentBean;
import org.ajax4jsf.builder.config.PropertyBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.InnerGenerator;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class ComponentGenerator
extends InnerGenerator {
    private static final String COMPONENT_FILE_TEMPLATE = "component.vm";

    public ComponentGenerator(JSFGeneratorConfiguration task, Logger log) {
        super(task, log);
    }

    public void createFiles(BuilderConfig config) throws GeneratorException {
        VelocityContext context = new VelocityContext();
        Template template = this.getTemplate();
        context.put("generator", (Object)this);
        for (ComponentBean component : config.getComponents()) {
            this.info("Create class file " + component.getClassname());
            if (!component.isGenerate()) continue;
            context.put("component", (Object)component);
            context.put("renderer", (Object)component.getRenderer());
            context.put("package", (Object)component.getPackageName());
            HashSet<String> importClasses = new HashSet<String>();
            for (PropertyBean property : component.getProperties()) {
                if (property.isSimpleType() || property.isExist()) continue;
                importClasses.add(property.getClassname());
            }
            importClasses.add(component.getSuperclass());
            context.put("imports", importClasses);
            String resultPath = component.getClassname().replace('.', '/') + ".java";
            File javaFile = new File(this.getDestDir(), resultPath);
            File javaDir = javaFile.getParentFile();
            if (!javaDir.exists()) {
                javaDir.mkdirs();
            }
            try {
                if (javaFile.exists()) {
                    javaFile.delete();
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(javaFile));
                template.merge((Context)context, (Writer)out);
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (Exception e) {
                throw new GeneratorException("Error create new Component Java file ", e);
            }
        }
    }

    protected String getDefaultTemplateName() {
        return COMPONENT_FILE_TEMPLATE;
    }
}

