/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.config;

import java.util.HashSet;
import java.util.Set;
import org.ajax4jsf.builder.config.ComponentBaseBean;
import org.ajax4jsf.builder.config.EventBean;
import org.ajax4jsf.builder.config.JsfBean;
import org.ajax4jsf.builder.config.ParsingException;
import org.ajax4jsf.builder.config.RendererBean;
import org.ajax4jsf.builder.config.TestClassHolder;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBean
extends ComponentBaseBean {
    private String _family;
    private Set<JsfBean> _facets = new HashSet<JsfBean>();
    private RendererBean renderer;
    private Set<EventBean> events = new HashSet<EventBean>();

    public Set<JsfBean> getFacets() {
        return this._facets;
    }

    public void addFacet(JsfBean facet) {
        this._facets.add(facet);
    }

    public String getFamily() {
        return this._family;
    }

    public void setFamily(String family) {
        this._family = family;
    }

    public RendererBean getRenderer() {
        return this.renderer;
    }

    public void setRenderer(RendererBean renderer) {
        this.renderer = renderer;
        renderer.setParent(this);
    }

    public Set<EventBean> getEvents() {
        return this.events;
    }

    public void addEvent(EventBean event) {
        this.events.add(event);
        event.setParent(this);
    }

    @Override
    public TestClassHolder getTest() {
        return super.getTest();
    }

    @Override
    public void setTest(TestClassHolder test) {
        super.setTest(test);
        test.setClassname(this.getClassname() + "ComponentTest");
    }

    @Override
    public void checkProperties() throws ParsingException {
        super.checkProperties();
        if (null != this.getRenderer()) {
            this.getRenderer().checkProperties();
        }
        for (EventBean event : this.getEvents()) {
            event.checkProperties();
        }
        if (null == this.getFamily()) {
            try {
                Class<?> superClass = this.getLoader().loadClass(this.getSuperclass());
                Object componentInstance = superClass.newInstance();
                String family = (String)PropertyUtils.getProperty(componentInstance, (String)"family");
                this.setFamily(family);
                this.getLog().debug("Detect family of component as " + family);
            }
            catch (Exception e) {
                this.getLog().error("Error for create instance of component " + this.getSuperclass() + " exception: " + e.getClass().getName() + " with message " + e.getMessage());
                throw new ParsingException("'Family' property not set for component" + this.getName());
            }
        }
    }
}

