/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;
import org.nuxeo.theme.styling.service.descriptors.FlavorDescriptor;

public class FlavorRegistry
extends ContributionFragmentRegistry<FlavorDescriptor> {
    protected Map<String, FlavorDescriptor> themePageFlavors = new HashMap<String, FlavorDescriptor>();

    public String getContributionId(FlavorDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, FlavorDescriptor contrib, FlavorDescriptor newOrigContrib) {
        this.themePageFlavors.put(id, contrib);
    }

    public synchronized void removeContribution(FlavorDescriptor contrib) {
        this.removeContribution(contrib, true);
    }

    public void contributionRemoved(String id, FlavorDescriptor origContrib) {
        this.themePageFlavors.remove(id);
    }

    public FlavorDescriptor clone(FlavorDescriptor orig) {
        if (orig == null) {
            return null;
        }
        return orig.clone();
    }

    public void merge(FlavorDescriptor src, FlavorDescriptor dst) {
        dst.merge(src);
    }

    public FlavorDescriptor getFlavor(String id) {
        return this.themePageFlavors.get(id);
    }

    public List<FlavorDescriptor> getFlavorsExtending(String flavor) {
        ArrayList<FlavorDescriptor> res = new ArrayList<FlavorDescriptor>();
        for (FlavorDescriptor f : this.themePageFlavors.values()) {
            String extendsFlavor;
            if (f == null || StringUtils.isBlank((CharSequence)(extendsFlavor = f.getExtendsFlavor())) || !extendsFlavor.equals(flavor)) continue;
            res.add(f);
        }
        return res;
    }
}

