/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.descriptors;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.web.resources.api.ResourceBundle;
import org.nuxeo.ecm.web.resources.api.ResourceType;
import org.nuxeo.ecm.web.resources.core.ResourceBundleDescriptor;

@XObject(value="page")
public class PageDescriptor {
    public static final String RESOURCE_BUNDLE_PREFIX = "pageResourceBundle_";
    @XNode(value="@name")
    String name;
    @XNode(value="@charset")
    String charset;
    @XNode(value="defaultFlavor")
    String defaultFlavor;
    @Deprecated
    @XNode(value="styles@append")
    boolean appendStyles;
    @Deprecated
    @XNodeList(value="styles/style", type=ArrayList.class, componentType=String.class)
    List<String> styles;
    @XNode(value="flavors@append")
    boolean appendFlavors;
    @XNodeList(value="flavors/flavor", type=ArrayList.class, componentType=String.class)
    List<String> flavors;
    @XNode(value="resources@append")
    boolean appendResources;
    @XNodeList(value="resources/resource", type=ArrayList.class, componentType=String.class)
    List<String> resources;
    @XNodeList(value="resources/bundle", type=ArrayList.class, componentType=String.class)
    List<String> bundles;

    public String getName() {
        return this.name;
    }

    public String getDefaultFlavor() {
        return this.defaultFlavor;
    }

    public void setDefaultFlavor(String defaultFlavor) {
        this.defaultFlavor = defaultFlavor;
    }

    public boolean getAppendStyles() {
        return this.appendStyles;
    }

    public List<String> getStyles() {
        return this.styles;
    }

    public boolean getAppendFlavors() {
        return this.appendFlavors;
    }

    public List<String> getFlavors() {
        return this.flavors;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStyles(List<String> styles) {
        this.styles = styles;
    }

    public void setFlavors(List<String> flavors) {
        this.flavors = flavors;
    }

    public boolean getAppendResources() {
        return this.appendResources;
    }

    public boolean hasResources() {
        return !this.getResources().isEmpty();
    }

    public List<String> getResources() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.styles != null) {
            for (String style : this.styles) {
                if (style == null) continue;
                if (style.endsWith(ResourceType.css.name())) {
                    res.add(style);
                    continue;
                }
                res.add(style + "." + ResourceType.css.name());
            }
        }
        if (this.resources != null) {
            res.addAll(this.resources);
        }
        return res;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public String getComputedResourceBundleName() {
        if ("*".equals(this.getName())) {
            return "pageResourceBundle_*";
        }
        return RESOURCE_BUNDLE_PREFIX + this.getName().replaceAll("[^a-zA-Z]+", "_");
    }

    public ResourceBundle getComputedResourceBundle() {
        if (this.hasResources()) {
            ResourceBundleDescriptor bundle = new ResourceBundleDescriptor();
            bundle.setName(this.getComputedResourceBundleName());
            bundle.setResources(this.getResources());
            bundle.setAppend(this.getAppendResources());
            return bundle;
        }
        return null;
    }

    public List<String> getResourceBundles() {
        ArrayList<String> all = new ArrayList<String>();
        if (this.bundles != null) {
            all.addAll(this.bundles);
        }
        if (this.hasResources()) {
            all.add(this.getComputedResourceBundleName());
        }
        return all;
    }

    public void setResourceBundles(List<String> bundles) {
        this.bundles = bundles;
    }

    public void setAppendStyles(boolean appendStyles) {
        this.appendStyles = appendStyles;
    }

    public void setAppendFlavors(boolean appendFlavors) {
        this.appendFlavors = appendFlavors;
    }

    public void setAppendResources(boolean appendResources) {
        this.appendResources = appendResources;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void merge(PageDescriptor src) {
        List<String> newBundles;
        List<String> newResources;
        List<String> newFlavors;
        List<String> newStyles;
        String newCharset;
        String newFlavor = src.getDefaultFlavor();
        if (newFlavor != null) {
            this.setDefaultFlavor(newFlavor);
        }
        if ((newCharset = src.getCharset()) != null) {
            this.setCharset(newCharset);
        }
        if ((newStyles = src.getStyles()) != null) {
            List<String> oldStyles;
            boolean keepOld;
            ArrayList<String> merged = new ArrayList<String>();
            merged.addAll(newStyles);
            boolean bl = keepOld = src.getAppendStyles() || newStyles.isEmpty() && !src.getAppendStyles();
            if (keepOld && (oldStyles = this.getStyles()) != null) {
                merged.addAll(0, oldStyles);
            }
            this.setStyles(merged);
        }
        if ((newFlavors = src.getFlavors()) != null) {
            List<String> oldFlavors;
            boolean keepOld;
            ArrayList<String> merged = new ArrayList<String>();
            merged.addAll(newFlavors);
            boolean bl = keepOld = src.getAppendFlavors() || newFlavors.isEmpty() && !src.getAppendFlavors();
            if (keepOld && (oldFlavors = this.getFlavors()) != null) {
                merged.addAll(0, oldFlavors);
            }
            this.setFlavors(merged);
        }
        if ((newResources = src.resources) != null) {
            List<String> oldResources;
            boolean keepOld;
            ArrayList<String> merged = new ArrayList<String>();
            merged.addAll(newResources);
            boolean bl = keepOld = src.getAppendResources() || newResources.isEmpty() && !src.getAppendResources();
            if (keepOld && (oldResources = this.resources) != null) {
                merged.addAll(0, oldResources);
            }
            this.setResources(merged);
        }
        if ((newBundles = src.bundles) != null) {
            List<String> oldBundles;
            boolean keepOld;
            ArrayList<String> merged = new ArrayList<String>();
            merged.addAll(newBundles);
            boolean bl = keepOld = src.getAppendResources() || newBundles.isEmpty() && !src.getAppendResources();
            if (keepOld && (oldBundles = this.bundles) != null) {
                merged.addAll(0, oldBundles);
            }
            this.setResourceBundles(merged);
        }
    }

    public PageDescriptor clone() {
        PageDescriptor clone = new PageDescriptor();
        clone.setName(this.getName());
        clone.setCharset(this.getCharset());
        clone.setDefaultFlavor(this.getDefaultFlavor());
        clone.setAppendStyles(this.getAppendStyles());
        List<String> styles = this.getStyles();
        if (styles != null) {
            clone.setStyles(new ArrayList<String>(styles));
        }
        clone.setAppendFlavors(this.getAppendFlavors());
        List<String> flavors = this.getFlavors();
        if (flavors != null) {
            clone.setFlavors(new ArrayList<String>(flavors));
        }
        clone.setAppendResources(this.getAppendResources());
        if (this.resources != null) {
            clone.setResources(new ArrayList<String>(this.resources));
        }
        if (this.bundles != null) {
            clone.setResourceBundles(new ArrayList<String>(this.bundles));
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PageDescriptor)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PageDescriptor p = (PageDescriptor)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)p.name).append((Object)this.charset, (Object)p.charset).append((Object)this.defaultFlavor, (Object)p.defaultFlavor).append(this.appendStyles, p.appendStyles).append(this.styles, p.styles).append(this.appendFlavors, p.appendFlavors).append(this.flavors, p.flavors).append(this.appendResources, p.appendResources).append(this.resources, p.resources).append(this.bundles, p.bundles).isEquals();
    }
}

