/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.io.download.BufferingServletOutputStream;
import org.nuxeo.theme.ApplicationType;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.html.Utils;
import org.nuxeo.theme.html.ui.ThemeStyles;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeFamily;

public final class Styles
extends HttpServlet
implements Serializable {
    private static final Log log = LogFactory.getLog(Styles.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ApplicationType application;
        String applicationPath;
        response.addHeader("content-type", "text/css");
        String themeName = request.getParameter("theme");
        if (themeName == null) {
            response.sendError(404);
            log.error((Object)"Theme name not set");
            return;
        }
        String collectionName = request.getParameter("collection");
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptorByThemeName((String)themeName);
        if (themeDescriptor == null) {
            throw new IOException("Theme not found: " + themeName);
        }
        if (!themeDescriptor.isLoaded()) {
            ThemeManager.loadTheme((ThemeDescriptor)themeDescriptor);
        }
        if ((applicationPath = request.getParameter("path")) != null && (application = (ApplicationType)Manager.getTypeRegistry().lookup(TypeFamily.APPLICATION, applicationPath)) != null) {
            Utils.setCacheHeaders(response, application.getStyleCaching());
        }
        Object os = response.getOutputStream();
        BufferingServletOutputStream.stopBuffering((OutputStream)os);
        if (Utils.supportsGzip(request)) {
            response.setHeader("Content-Encoding", "gzip");
            response.setHeader("Vary", "Accept-Encoding");
            os = new GZIPOutputStream((OutputStream)os);
        }
        String basePath = request.getParameter("basepath");
        ThemeManager themeManager = Manager.getThemeManager();
        String rendered = themeManager.getCachedStyles(themeName, basePath, collectionName);
        if (rendered == null) {
            rendered = ThemeStyles.generateThemeStyles(themeName, themeDescriptor, basePath, collectionName, true);
            themeManager.setCachedStyles(themeName, basePath, collectionName, rendered);
        }
        ((OutputStream)os).write(rendered.getBytes());
        ((OutputStream)os).close();
    }
}

